/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class RelicAttributeModifier {
    List<Modifier> attributes;

    RelicAttributeModifier(List<Modifier> attributes) {
        this.attributes = attributes;
    }

    public static RelicAttributeModifierBuilder builder() {
        return new RelicAttributeModifierBuilder();
    }

    public List<Modifier> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Modifier> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicAttributeModifier)) {
            return false;
        }
        RelicAttributeModifier other = (RelicAttributeModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Modifier> this$attributes = this.getAttributes();
        List<Modifier> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelicAttributeModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Modifier> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "RelicAttributeModifier(attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    public static class RelicAttributeModifierBuilder {
        private ArrayList<Modifier> attributes;

        RelicAttributeModifierBuilder() {
        }

        public RelicAttributeModifierBuilder attribute(Modifier attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return this;
        }

        public RelicAttributeModifierBuilder attributes(Collection<? extends Modifier> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return this;
        }

        public RelicAttributeModifierBuilder clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return this;
        }

        public RelicAttributeModifier build() {
            return new RelicAttributeModifier(switch (this.attributes == null ? 0 : this.attributes.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.attributes.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Modifier>(this.attributes));
            });
        }

        public String toString() {
            return "RelicAttributeModifier.RelicAttributeModifierBuilder(attributes=" + String.valueOf(this.attributes) + ")";
        }
    }

    public static class Modifier {
        private final Holder<Attribute> attribute;
        private final float multiplier;
        private final AttributeModifier.Operation operation;

        public Modifier(Holder<Attribute> attribute, float multiplier, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.multiplier = multiplier;
            this.operation = operation;
        }

        public Modifier(Holder<Attribute> attribute, float multiplier) {
            this.attribute = attribute;
            this.multiplier = multiplier;
            this.operation = AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
        }

        public Holder<Attribute> getAttribute() {
            return this.attribute;
        }

        public float getMultiplier() {
            return this.multiplier;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
                return false;
            }
            Holder<Attribute> this$attribute = this.getAttribute();
            Holder<Attribute> other$attribute = other.getAttribute();
            if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
                return false;
            }
            AttributeModifier.Operation this$operation = this.getOperation();
            AttributeModifier.Operation other$operation = other.getOperation();
            return !(this$operation == null ? other$operation != null : !this$operation.equals(other$operation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Modifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getMultiplier());
            Holder<Attribute> $attribute = this.getAttribute();
            result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
            AttributeModifier.Operation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
            return result;
        }

        public String toString() {
            return "RelicAttributeModifier.Modifier(attribute=" + String.valueOf(this.getAttribute()) + ", multiplier=" + this.getMultiplier() + ", operation=" + String.valueOf(this.getOperation()) + ")";
        }
    }
}

