/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.hrznstudio.titanium.network.CompoundSerializableDataHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.neoforge.common.Tags;

public record LaserDrillRarity(BiomeRarity biomeRarity, DimensionRarity dimensionRarity, int depth_min, int depth_max, int weight) {
    public static final Codec<LaserDrillRarity> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(laserDrillRarityInstance -> laserDrillRarityInstance.group((App)BiomeRarity.CODEC.fieldOf("biome_filter").forGetter(o -> o.biomeRarity), (App)DimensionRarity.CODEC.fieldOf("dimension_filter").forGetter(o -> o.dimensionRarity), (App)Codec.INT.fieldOf("depth_min").forGetter(o -> o.depth_min), (App)Codec.INT.fieldOf("depth_max").forGetter(o -> o.depth_max), (App)Codec.INT.fieldOf("weight").forGetter(o -> o.weight)).apply((Applicative)laserDrillRarityInstance, LaserDrillRarity::new)));

    public static void init() {
        CompoundSerializableDataHandler.map(LaserDrillRarity.class, buf -> (LaserDrillRarity)buf.readJsonWithCodec(CODEC), (buf, laserDrillRarity) -> buf.writeJsonWithCodec(CODEC, laserDrillRarity));
    }

    @Nullable
    public static LaserDrillRarity getValidRarity(Level level, List<LaserDrillRarity> rarities, DimensionType dimensionType, Holder<Biome> biome, int height) {
        for (LaserDrillRarity laserDrillRarity : rarities) {
            if (laserDrillRarity.depth_max() < height || laserDrillRarity.depth_min() > height || !LaserDrillRarity.checkForBiome(laserDrillRarity, biome) || !LaserDrillRarity.checkForDimension(level, laserDrillRarity, dimensionType)) continue;
            return laserDrillRarity;
        }
        return null;
    }

    private static boolean checkForDimension(Level level, LaserDrillRarity rarity, DimensionType dimensionType) {
        return rarity.dimensionRarity().whitelist().isEmpty() ? rarity.dimensionRarity().blacklist().stream().noneMatch(dimensionTypeResourceKey -> ((DimensionType)level.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).get(dimensionTypeResourceKey)).equals((Object)dimensionType)) : rarity.dimensionRarity().whitelist().stream().anyMatch(dimensionTypeResourceKey -> ((DimensionType)level.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).get(dimensionTypeResourceKey)).equals((Object)dimensionType));
    }

    private static boolean checkForBiome(LaserDrillRarity rarity, Holder<Biome> biome) {
        return rarity.biomeRarity().whitelist().isEmpty() ? rarity.biomeRarity().blacklist().stream().noneMatch(arg_0 -> biome.is(arg_0)) : rarity.biomeRarity().whitelist().stream().anyMatch(arg_0 -> biome.is(arg_0));
    }

    public record BiomeRarity(List<TagKey<Biome>> whitelist, List<TagKey<Biome>> blacklist) {
        public static final MapCodec<BiomeRarity> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)TagKey.codec((ResourceKey)Registries.BIOME).listOf().fieldOf("whitelist").forGetter(o -> o.whitelist), (App)TagKey.codec((ResourceKey)Registries.BIOME).listOf().fieldOf("blacklist").forGetter(o -> o.blacklist)).apply((Applicative)in, BiomeRarity::new));
        public static List<TagKey<Biome>> END = List.of(BiomeTags.IS_END);
        public static List<TagKey<Biome>> NETHER = List.of(BiomeTags.IS_NETHER);
        public static List<TagKey<Biome>> OIL = List.of(BiomeTags.IS_OCEAN, Tags.Biomes.IS_DESERT);
    }

    public record DimensionRarity(List<ResourceKey<DimensionType>> whitelist, List<ResourceKey<DimensionType>> blacklist) {
        public static final MapCodec<DimensionRarity> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION_TYPE).listOf().fieldOf("whitelist").forGetter(o -> o.whitelist), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION_TYPE).listOf().fieldOf("blacklist").forGetter(o -> o.blacklist)).apply((Applicative)in, DimensionRarity::new));
    }
}

