/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client;

import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.entity.client.InfinityLauncherProjectileArmorLayer;
import com.buuz135.industrial.entity.client.InfinityLauncherProjectileModel;
import com.buuz135.industrial.entity.client.InfinityLauncherProjectileRenderer;
import com.buuz135.industrial.entity.client.InfinityNukeModel;
import com.buuz135.industrial.entity.client.InfinityNukeModelArmed;
import com.buuz135.industrial.entity.client.InfinityNukeRenderer;
import com.buuz135.industrial.entity.client.InfinityTridentModel;
import com.buuz135.industrial.entity.client.InfinityTridentRenderer;
import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.client.event.IFClientEvents;
import com.buuz135.industrial.proxy.client.render.ContributorsCatEarsRender;
import com.buuz135.industrial.proxy.client.render.FluidConveyorTESR;
import com.buuz135.industrial.proxy.client.render.MycelialReactorTESR;
import com.buuz135.industrial.proxy.client.render.TransporterTESR;
import com.buuz135.industrial.proxy.client.render.WorkingAreaTESR;
import com.buuz135.industrial.proxy.client.render.item.HydroponicSimProcessorISTER;
import com.buuz135.industrial.utils.FluidUtils;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.BlockWithTile;
import java.util.Calendar;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientProxy
extends CommonProxy {
    public static ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
    public static BakedModel ears_baked;
    public static BakedModel HYDROPONIC_SIM_PROCESSOR;
    public static KeyMapping OPEN_BACKPACK;

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientProxy.registerAreaRender(event, ModuleCore.FLUID_EXTRACTOR);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.PLANT_GATHERER);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.PLANT_SOWER);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.SEWER);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.PLANT_FERTILIZER);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.SLAUGHTER_FACTORY);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.ANIMAL_RANCHER);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.ANIMAL_FEEDER);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.ANIMAL_BABY_SEPARATOR);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.MOB_CRUSHER);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.WITHER_BUILDER);
        ClientProxy.registerAreaRender(event, ModuleMisc.STASIS_CHAMBER);
        ClientProxy.registerAreaRender(event, ModuleResourceProduction.LASER_DRILL);
        ClientProxy.registerAreaRender(event, ModuleAgricultureHusbandry.MOB_DUPLICATOR);
        event.registerBlockEntityRenderer((BlockEntityType)ModuleGenerator.MYCELIAL_REACTOR.type().get(), MycelialReactorTESR::new);
        event.registerEntityRenderer((EntityType)ModuleTool.TRIDENT_ENTITY_TYPE.value(), InfinityTridentRenderer::new);
        event.registerEntityRenderer((EntityType)ModuleTool.INFINITY_NUKE_ENTITY_TYPE.value(), InfinityNukeRenderer::new);
        event.registerEntityRenderer((EntityType)ModuleTool.INFINITY_LAUNCHER_PROJECTILE_ENTITY_TYPE.value(), InfinityLauncherProjectileRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModuleTransportStorage.TRANSPORTER.type().get(), TransporterTESR::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModuleTransportStorage.CONVEYOR.type().get(), FluidConveyorTESR::new);
    }

    private static void registerAreaRender(EntityRenderersEvent.RegisterRenderers event, BlockWithTile pair) {
        event.registerBlockEntityRenderer((BlockEntityType)pair.type().get(), WorkingAreaTESR::new);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        for (PlayerSkin.Model skin : event.getSkins()) {
            EntityRenderer renderer = event.getSkin(skin);
            if (!(renderer instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.addLayer((RenderLayer)new ContributorsCatEarsRender((LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)playerRenderer));
            playerRenderer.addLayer(new InfinityLauncherProjectileArmorLayer(playerRenderer));
        }
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(InfinityTridentRenderer.TRIDENT_LAYER, InfinityTridentModel::createBodyLayer);
        event.registerLayerDefinition(InfinityNukeRenderer.NUKE_LAYER, InfinityNukeModel::createBodyLayer);
        event.registerLayerDefinition(InfinityNukeRenderer.NUKE_ARMED_LAYER, () -> InfinityNukeModelArmed.createBodyLayer(new CubeDeformation(0.0f)));
        event.registerLayerDefinition(InfinityNukeRenderer.NUKE_ARMED_BIG_LAYER, () -> InfinityNukeModelArmed.createBodyLayer(new CubeDeformation(0.2f)));
        event.registerLayerDefinition(InfinityLauncherProjectileRenderer.PROJECTILE_LAYER, InfinityLauncherProjectileModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return HydroponicSimProcessorISTER.INSTANCE;
            }
        }, new Item[]{(Item)ModuleAgricultureHusbandry.HYDROPONIC_SIMULATION_PROCESSOR.get()});
    }

    @Override
    public void run() {
        NeoForge.EVENT_BUS.register((Object)new IFClientEvents());
        ItemBlockRenderTypes.setRenderLayer((Block)ModuleTransportStorage.CONVEYOR.getBlock(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)ModuleTool.INFINITY_BACKPACK_BLOCK.getBlock(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModuleCore.PINK_SLIME_BLOCK.get()), (RenderType)RenderType.translucent());
        Minecraft.getInstance().getBlockColors().register((state, worldIn, pos, tintIndex) -> {
            BlockEntity entity;
            if (tintIndex == 0 && worldIn != null && pos != null && (entity = worldIn.getBlockEntity(pos)) instanceof ConveyorTile) {
                return ((ConveyorTile)entity).getColor();
            }
            return -1;
        }, new Block[]{ModuleTransportStorage.CONVEYOR.getBlock()});
        Minecraft.getInstance().getItemColors().register((stack, tintIndex) -> {
            if (tintIndex == 1 || tintIndex == 2 || tintIndex == 3) {
                SpawnEggItem info = null;
                boolean blacklisted = false;
                if (stack.has(IFAttachments.MOB_IMPRISONMENT_TOOL)) {
                    CompoundTag tag = (CompoundTag)stack.get(IFAttachments.MOB_IMPRISONMENT_TOOL);
                    ResourceLocation id = ResourceLocation.parse((String)tag.getString("entity"));
                    EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
                    info = SpawnEggItem.byId((EntityType)type);
                    blacklisted = ((MobImprisonmentToolItem)((Object)((Object)ModuleTool.MOB_IMPRISONMENT_TOOL.get()))).isBlacklisted(type);
                }
                return info == null ? -10263709 : (tintIndex == 3 ? (blacklisted ? -2416614 : -10263709) : FastColor.ARGB32.opaque((int)info.getColor(tintIndex - 1)));
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModuleTool.MOB_IMPRISONMENT_TOOL.get()});
        Minecraft.getInstance().getItemColors().register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return FastColor.ARGB32.opaque((int)((InfinityTier)((Object)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()))).getTextureColor());
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModuleTool.INFINITY_BACKPACK.get(), (ItemLike)ModuleTool.INFINITY_LAUNCHER.get(), (ItemLike)ModuleTool.INFINITY_NUKE.get(), (ItemLike)ModuleTool.INFINITY_TRIDENT.get(), (ItemLike)ModuleTool.INFINITY_HAMMER.get(), (ItemLike)ModuleTool.INFINITY_SAW.get(), (ItemLike)ModuleTool.INFINITY_DRILL.get()});
        Minecraft.getInstance().getItemColors().register((stack, tintIndex) -> {
            int color;
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (tintIndex == 1 && fluidHandlerItem != null && fluidHandlerItem.getFluidInTank(0).getAmount() > 0 && (color = FluidUtils.getFluidColor(fluidHandlerItem.getFluidInTank(0))) != -1) {
                return FastColor.ARGB32.opaque((int)color);
            }
            return -1;
        }, new ItemLike[]{ModuleCore.RAW_ORE_MEAT.getBucketFluid(), ModuleCore.FERMENTED_ORE_MEAT.getBucketFluid()});
        EventManager.forge(ItemTooltipEvent.class).filter(event -> BuiltInRegistries.ITEM.getKey((Object)event.getItemStack().getItem()).getNamespace().equals("industrialforegoing")).process(event -> {
            if (Calendar.getInstance().get(5) == 1 && Calendar.getInstance().get(2) == 3) {
                event.getToolTip().add(Component.literal((String)Component.translatable((String)"text.industrialforegoing.proxy.client.alt_f4").getString()).withStyle(ChatFormatting.DARK_AQUA));
            }
        }).subscribe();
        Minecraft instance = Minecraft.getInstance();
        EntityRenderDispatcher manager = instance.getEntityRenderDispatcher();
        ItemProperties.register((Item)((Item)ModuleTool.INFINITY_LAUNCHER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"cooldown"), (stack, world, entity, number) -> {
            if (entity instanceof Player) {
                return ((Player)entity).getCooldowns().isOnCooldown(stack.getItem()) ? 1.0f : 2.0f;
            }
            return 2.0f;
        });
        ItemProperties.register((Item)((Item)ModuleCore.MACHINE_SETTINGS_COPIER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"stored"), (stack, world, entity, number) -> stack.has(IFAttachments.SETTINGS_COPIER) ? 1.0f : 0.0f);
    }
}

