/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tool.tile;

import com.buuz135.industrial.item.infinity.item.ItemInfinityBackpack;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class InfinityBackpackTile
extends BasicTile<InfinityBackpackTile>
implements MenuProvider,
IScreenAddonProvider,
IButtonHandler,
ITickableBlockEntity<InfinityBackpackTile> {
    @Save
    private ItemStack backpack = ItemStack.EMPTY;

    public InfinityBackpackTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)ModuleTool.INFINITY_BACKPACK_BLOCK.getBlock(), (BlockEntityType)ModuleTool.INFINITY_BACKPACK_BLOCK.type().get(), pos, state);
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }

    public void setBackpack(ItemStack backpack) {
        this.backpack = backpack;
        if (!this.backpack.has(IFAttachments.INFINITY_BACKPACK_ID)) {
            UUID id = UUID.randomUUID();
            BackpackDataManager.getData((LevelAccessor)this.getLevel()).createBackPack(id);
            this.backpack.set(IFAttachments.INFINITY_BACKPACK_ID, (Object)id.toString());
        }
        this.syncObject(this.backpack);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, InfinityBackpackTile blockEntity) {
        IFluidHandlerItem handlerItem;
        if (level.getGameTime() % 4L == 0L) {
            for (Player entitiesOfClass : this.level.getEntitiesOfClass(Player.class, new AABB(this.getBlockPos()).inflate(8.0))) {
                if (!(entitiesOfClass instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entitiesOfClass;
                ItemInfinityBackpack.sync(this.getLevel(), (String)this.backpack.get(IFAttachments.INFINITY_BACKPACK_ID), serverPlayer);
                this.syncObject(this.backpack);
            }
        }
        if (level.getGameTime() % 2L == 0L && (ItemInfinityBackpack.getPickUpMode(this.getBackpack()) == 1 || ItemInfinityBackpack.getPickUpMode(this.getBackpack()) == 0) && ItemInfinityBackpack.isMagnetEnabled(this.getBackpack())) {
            for (ItemEntity itemEntity : level.getEntitiesOfClass(ItemEntity.class, new AABB(this.getBlockPos()).inflate(5.0))) {
                if (itemEntity.hasPickUpDelay() || !((ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get()).enoughFuel(this.getBackpack())) continue;
                this.pickupItem(itemEntity, this.getBackpack());
                ((ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get()).consumeFuel(this.getBackpack());
                this.syncObject(this.backpack);
            }
        }
        if (level.getGameTime() % 2L == 0L && (ItemInfinityBackpack.getPickUpMode(this.getBackpack()) == 2 || ItemInfinityBackpack.getPickUpMode(this.getBackpack()) == 0) && (handlerItem = (IFluidHandlerItem)this.getBackpack().getCapability(Capabilities.FluidHandler.ITEM)) != null) {
            for (ExperienceOrb entity : level.getEntitiesOfClass(ExperienceOrb.class, new AABB(this.getBlockPos()).inflate(5.0))) {
                if (!((ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get()).enoughFuel(this.getBackpack()) || handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), entity.getValue() * 20), IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), entity.getValue() * 20), IFluidHandler.FluidAction.EXECUTE);
                entity.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    private void pickupItem(ItemEntity itemEntity, ItemStack stack) {
        BackpackDataManager.BackpackItemHandler handler;
        BackpackDataManager manager = BackpackDataManager.getData((LevelAccessor)this.getLevel());
        if (manager != null && stack.has(IFAttachments.INFINITY_BACKPACK_ID) && (handler = manager.getBackpack((String)stack.get(IFAttachments.INFINITY_BACKPACK_ID))) != null) {
            ItemStack picked = itemEntity.getItem();
            for (int pos = 0; pos < handler.getSlots(); ++pos) {
                ItemStack slotStack = handler.getSlotDefinition(pos).getStack().copy();
                slotStack.setCount(1);
                if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)picked, (ItemStack)slotStack)) continue;
                ItemStack returned = handler.insertItem(pos, picked.copy(), false);
                picked.setCount(returned.getCount());
                return;
            }
        }
    }

    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (!player.isShiftKeyDown() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.backpack.isEmpty()) {
                ItemInfinityBackpack.sync(this.getLevel(), (String)this.backpack.get(IFAttachments.INFINITY_BACKPACK_ID), serverPlayer);
                this.syncObject(this.backpack);
                serverPlayer.openMenu((MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new TileEntityLocatorInstance(this.worldPosition)));
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public MenuProvider getStackMenuProvider() {
        return (MenuProvider)ModuleTool.INFINITY_BACKPACK.get();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new BasicAddonContainer((Object)this, (LocatorInstance)new TileEntityLocatorInstance(this.worldPosition), this.getWorldPosCallable(), inventoryPlayer, menu);
    }

    @Nonnull
    public Component getDisplayName() {
        return this.getStackMenuProvider().getDisplayName();
    }

    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        IFluidHandlerItem fluidHandlerItem;
        ItemInfinityBackpack backpackItem = (ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get();
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>(backpackItem.getScreenAddons(this::getBackpack));
        IEnergyStorage energy = (IEnergyStorage)this.backpack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy instanceof IScreenAddonProvider) {
            IScreenAddonProvider addonProvider = (IScreenAddonProvider)energy;
            addons.addAll(addonProvider.getScreenAddons());
        }
        if ((fluidHandlerItem = (IFluidHandlerItem)this.backpack.getCapability(Capabilities.FluidHandler.ITEM)) instanceof IScreenAddonProvider) {
            IScreenAddonProvider addonProvider = (IScreenAddonProvider)fluidHandlerItem;
            addons.addAll(addonProvider.getScreenAddons());
        }
        return addons;
    }

    public ContainerLevelAccess getWorldPosCallable() {
        return this.getLevel() != null ? ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()) : ContainerLevelAccess.NULL;
    }

    public void handleButtonMessage(int i, Player player, CompoundTag compoundTag) {
        ItemInfinityBackpack backpackItem = (ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get();
        backpackItem.handleButtonMessage(i, player, compoundTag, this.getBackpack());
        this.syncObject(this.backpack);
    }
}

