/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.metadata.CustomValueImpl;
import net.fabricmc.loader.impl.metadata.SimplePerson;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FMLModMetadata
implements ModMetadata {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final IModInfo modInfo;
    private final Version version;
    private final Collection<Person> authors;
    private final Map<String, CustomValue> customValues;

    public FMLModMetadata(IModInfo modInfo) {
        this.modInfo = modInfo;
        this.version = (Version)LambdaExceptionUtils.uncheck(() -> Version.parse(this.modInfo.getVersion().toString()));
        this.authors = modInfo.getConfig().getConfigElement(new String[]{"authors"}).stream().flatMap(obj -> {
            Stream<Object> stream;
            if (obj instanceof List) {
                List list = (List)obj;
                stream = list.stream();
            } else {
                stream = Stream.of(obj.toString().split(","));
            }
            return stream;
        }).map(SimplePerson::new).toList();
        this.customValues = this.modInfo.getModProperties().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> FMLModMetadata.convertModProperty(e.getValue())));
    }

    @Override
    public String getType() {
        return "fabric";
    }

    @Override
    public String getId() {
        return this.modInfo.getModId();
    }

    @Override
    public Collection<String> getProvides() {
        ArrayList<String> modProvides = new ArrayList<String>(this.modInfo.getConfig().getConfigElement(new String[]{"provides"}).orElseGet(List::of));
        if (modProvides.isEmpty() && this.getId().contains("_")) {
            String normalized = this.getId().replace('_', '-');
            modProvides.add(normalized);
        }
        modProvides.addAll(FabricLoaderImpl.INSTANCE.getModAliases(this.getId()));
        return modProvides;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public ModEnvironment getEnvironment() {
        return ModEnvironment.UNIVERSAL;
    }

    @Override
    public Collection<ModDependency> getDependencies() {
        return Set.of();
    }

    @Override
    public String getName() {
        return this.modInfo.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.modInfo.getDescription();
    }

    @Override
    public Collection<Person> getAuthors() {
        return this.authors;
    }

    @Override
    public Collection<Person> getContributors() {
        return Set.of();
    }

    @Override
    public ContactInformation getContact() {
        return ContactInformation.EMPTY;
    }

    @Override
    public Collection<String> getLicense() {
        return List.of(this.modInfo.getOwningFile().getLicense());
    }

    @Override
    public Optional<String> getIconPath(int size) {
        return this.modInfo.getLogoFile();
    }

    @Override
    public boolean containsCustomValue(String key) {
        return this.modInfo.getModProperties().containsKey(key);
    }

    @Override
    public CustomValue getCustomValue(String key) {
        return this.customValues.get(key);
    }

    @Override
    public Map<String, CustomValue> getCustomValues() {
        return this.customValues;
    }

    @Override
    public boolean containsCustomElement(String key) {
        return this.containsCustomValue(key);
    }

    @Nullable
    private static CustomValue convertModProperty(@Nullable Object value) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnmodifiableConfig.class, ArrayList.class, Boolean.class, String.class, Number.class}, (Object)object, n)) {
            case -1: {
                return CustomValueImpl.NULL;
            }
            case 0: {
                UnmodifiableConfig config = (UnmodifiableConfig)object;
                Map<String, CustomValue> entries = config.entrySet().stream().collect(Collectors.toMap(UnmodifiableConfig.Entry::getKey, e -> FMLModMetadata.convertModProperty(e.getValue())));
                return new CustomValueImpl.ObjectImpl(entries);
            }
            case 1: {
                ArrayList list = (ArrayList)object;
                List<CustomValue> contents = list.stream().map(FMLModMetadata::convertModProperty).toList();
                return new CustomValueImpl.ArrayImpl(contents);
            }
            case 2: {
                Boolean b = (Boolean)object;
                return b != false ? CustomValueImpl.BOOLEAN_TRUE : CustomValueImpl.BOOLEAN_FALSE;
            }
            case 3: {
                String str = (String)object;
                return new CustomValueImpl.StringImpl(str);
            }
            case 4: {
                Number num = (Number)object;
                return new CustomValueImpl.NumberImpl(num);
            }
        }
        LOGGER.warn("Ignoring custom mod property value '{}' of unsupported type '{}'", value, (Object)value.getClass().getName());
        return null;
    }
}

