/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.util;

import info.u_team.overworld_mirror.config.CommonConfig;
import info.u_team.u_team_core.util.LevelUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class SeedUtil {
    public static long getOverworldMirrorSeed(MinecraftServer server) {
        return ((OverworldMirrorSeedSavedData)LevelUtil.getSaveData((ServerLevel)server.overworld(), (String)"overworldmirror_seed", OverworldMirrorSeedSavedData::load, () -> {
            OverworldMirrorSeedSavedData data = new OverworldMirrorSeedSavedData(SeedUtil.getOverworldMirrorSeedConfigValue(server));
            data.setDirty();
            return data;
        })).getSeed();
    }

    private static long getOverworldMirrorSeedConfigValue(MinecraftServer server) {
        long seedValue = (Long)CommonConfig.getInstance().seed().get();
        if (((Boolean)CommonConfig.getInstance().seedAddition().get()).booleanValue()) {
            long overworldSeed = server.getWorldData().worldGenOptions().seed();
            return overworldSeed + seedValue;
        }
        return seedValue;
    }

    private static class OverworldMirrorSeedSavedData
    extends SavedData {
        private long seed;

        public OverworldMirrorSeedSavedData(long seed) {
            this.seed = seed;
        }

        public static OverworldMirrorSeedSavedData load(CompoundTag compound, HolderLookup.Provider provider) {
            return new OverworldMirrorSeedSavedData(compound.getLong("seed"));
        }

        public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
            compound.putLong("seed", this.seed);
            return compound;
        }

        public long getSeed() {
            return this.seed;
        }
    }
}

