/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.portal;

import info.u_team.overworld_mirror.block.OverworldMirrorPortalBlock;
import info.u_team.overworld_mirror.config.CommonConfig;
import info.u_team.overworld_mirror.init.OverworldMirrorBlocks;
import info.u_team.overworld_mirror.portal.PortalLevelSavedData;
import info.u_team.u_team_core.util.LevelUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class PortalManager {
    public static boolean trySpawnPortalFromFrame(ServerLevel level, BlockPos pos) {
        int northCount;
        int westCount;
        for (westCount = 0; level.getBlockState(pos.west(westCount + 1)).getBlock() != Blocks.STONE_BRICKS && westCount < 3; ++westCount) {
        }
        BlockPos westPost = pos.west(westCount);
        for (northCount = 0; level.getBlockState(westPost.north(northCount + 1)).getBlock() != Blocks.STONE_BRICKS && northCount < 3; ++northCount) {
        }
        BlockPos westNorthPos = westPost.north(northCount);
        BlockPos middlePos = westNorthPos.east().south();
        if (!PortalManager.validatePortalFrameAndSpawnPortal((Level)level, middlePos)) {
            return false;
        }
        PortalLevelSavedData data = PortalManager.getSavedData(level);
        data.getPortals().add(middlePos);
        data.setDirty();
        return true;
    }

    private static boolean validatePortalFrameAndSpawnPortal(Level level, BlockPos pos) {
        int i;
        ArrayList<BlockPos> flowers = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                flowers.add(pos.offset(i, 0, j));
            }
        }
        for (i = -1; i <= 1; ++i) {
            frame.add(pos.offset(2, 0, i));
            frame.add(pos.offset(-2, 0, i));
            frame.add(pos.offset(i, 0, 2));
            frame.add(pos.offset(i, 0, -2));
        }
        boolean flowersMatching = flowers.stream().allMatch(flowerPos -> level.getBlockState(flowerPos).getBlock() instanceof FlowerBlock);
        boolean frameMatching = frame.stream().allMatch(framePos -> level.getBlockState(framePos).getBlock() == Blocks.STONE_BRICKS);
        if (flowersMatching && frameMatching) {
            flowers.forEach(portalPos -> level.setBlock(portalPos, ((OverworldMirrorPortalBlock)((Object)((Object)OverworldMirrorBlocks.PORTAL.get()))).defaultBlockState(), 2));
            PlayerList playerlist = level.getServer().getPlayerList();
            flowers.forEach(portalPos -> playerlist.broadcast(null, (double)portalPos.getX(), (double)portalPos.getY(), (double)portalPos.getZ(), 64.0, level.dimension(), (Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, portalPos)));
            return true;
        }
        return false;
    }

    public static DimensionTransition findOrCreatePortal(ServerLevel destinationLevel, Entity entity) {
        WorldBorder border = destinationLevel.getWorldBorder();
        double coordinateScale = DimensionType.getTeleportationScale((DimensionType)entity.getCommandSenderWorld().dimensionType(), (DimensionType)destinationLevel.dimensionType());
        BlockPos estimatedPos = border.clampToBounds(entity.getX() * coordinateScale, entity.getY(), entity.getZ() * coordinateScale);
        PortalLevelSavedData data = PortalManager.getSavedData(destinationLevel);
        CommonConfig config = CommonConfig.getInstance();
        double searchDistance = Math.pow(destinationLevel.dimension() == Level.OVERWORLD ? (Double)config.portalSearchDistanceOverworld().get() : (Double)config.portalSearchDistanceOverworldMirror().get(), 2.0);
        BlockPos portalMiddlePos = null;
        Iterator<BlockPos> iterator = data.getPortals().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (!((double)PortalManager.getPlaneDistanceSq(pos.getX(), pos.getZ(), estimatedPos.getX(), estimatedPos.getZ()) < searchDistance)) continue;
            if (PortalManager.validatePortal((Level)destinationLevel, pos)) {
                portalMiddlePos = pos;
                break;
            }
            iterator.remove();
            data.setDirty();
        }
        if (portalMiddlePos == null) {
            portalMiddlePos = PortalManager.spawnPortal((Level)destinationLevel, estimatedPos);
            data.getPortals().add(portalMiddlePos);
            data.setDirty();
        }
        return new DimensionTransition(destinationLevel, Vec3.upFromBottomCenterOf((Vec3i)portalMiddlePos, (double)0.25), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.PLACE_PORTAL_TICKET);
    }

    private static boolean validatePortal(Level level, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (level.getBlockState(pos.offset(i, 0, j)).getBlock() == OverworldMirrorBlocks.PORTAL.get()) continue;
                return false;
            }
        }
        return true;
    }

    private static BlockPos spawnPortal(Level level, BlockPos entityPos) {
        int i;
        level.getChunk(entityPos);
        BlockPos pos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, entityPos).below();
        ArrayList<BlockPos> portal = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                portal.add(pos.offset(i, 0, j));
            }
        }
        for (i = -2; i <= 2; ++i) {
            frame.add(pos.offset(2, 0, i));
            frame.add(pos.offset(-2, 0, i));
            frame.add(pos.offset(i, 0, 2));
            frame.add(pos.offset(i, 0, -2));
        }
        frame.forEach(framePos -> {
            level.setBlockAndUpdate(framePos, Blocks.STONE_BRICKS.defaultBlockState());
            level.removeBlock(framePos.above(), false);
            level.removeBlock(framePos.above(2), false);
        });
        portal.forEach(portalPos -> {
            level.removeBlock(portalPos.above(), false);
            level.removeBlock(portalPos.above(2), false);
            level.setBlockAndUpdate(portalPos.below(), Blocks.STONE_BRICKS.defaultBlockState());
        });
        portal.forEach(portalPos -> level.setBlock(portalPos, ((OverworldMirrorPortalBlock)((Object)((Object)OverworldMirrorBlocks.PORTAL.get()))).defaultBlockState(), 2));
        return pos;
    }

    public static PortalLevelSavedData getSavedData(ServerLevel level) {
        String name = "overworldmirror_portal";
        return (PortalLevelSavedData)LevelUtil.getSaveData((ServerLevel)level, (String)"overworldmirror_portal", PortalLevelSavedData::load, PortalLevelSavedData::new);
    }

    public static float getPlaneDistanceSq(int x1, int z1, int x2, int z2) {
        int xDiff = x2 - x1;
        int zDiff = z2 - z1;
        return xDiff * xDiff + zDiff * zDiff;
    }
}

