/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.google.common.collect.Sets;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.BitSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class SpiderDungeonPiece
extends StructurePiece {
    protected static final Set<Block> BLOCK_BLACKLIST = Sets.newHashSet((Object[])new Block[]{Blocks.DIAMOND_BLOCK, Blocks.WHITE_WOOL, Blocks.SPAWNER, Blocks.CHEST, Blocks.ACACIA_LEAVES, Blocks.BIRCH_LEAVES, Blocks.OAK_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.SPRUCE_LEAVES, Blocks.SHORT_GRASS, Blocks.TALL_GRASS});

    protected SpiderDungeonPiece(StructurePieceType structurePieceTypeIn, int chainLength, BoundingBox box) {
        super(structurePieceTypeIn, chainLength, box);
    }

    public SpiderDungeonPiece(StructurePieceType structurePierceTypeIn, CompoundTag compoundTag) {
        super(structurePierceTypeIn, compoundTag);
    }

    protected void decorateCave(WorldGenLevel world, RandomSource decoRand, ChunkPos chunkPos, BoundingBox box, BitSet carvingMask) {
        carvingMask.stream().forEach(mask -> {
            if (decoRand.nextFloat() < 0.15f) {
                int globalZ;
                int x = mask & 0xF;
                int z = mask >> 4 & 0xF;
                int globalX = x + chunkPos.x * 16;
                int y = (mask >> 8) + world.getMinBuildHeight();
                if ((this.getBlock((BlockGetter)world, globalX - 1, y, globalZ = z + chunkPos.z * 16, box).canOcclude() || this.getBlock((BlockGetter)world, globalX + 1, y, globalZ, box).canOcclude() || this.getBlock((BlockGetter)world, globalX, y, globalZ - 1, box).canOcclude() || this.getBlock((BlockGetter)world, globalX, y, globalZ + 1, box).canOcclude() || this.getBlock((BlockGetter)world, globalX, y - 1, globalZ, box).canOcclude() || this.getBlock((BlockGetter)world, globalX, y + 1, globalZ, box).canOcclude()) && !BLOCK_BLACKLIST.contains(this.getBlock((BlockGetter)world, globalX, y, globalZ, box).getBlock())) {
                    this.placeBlock(world, Blocks.COBWEB.defaultBlockState(), globalX, y, globalZ, box);
                }
            }
        });
    }

    protected void placeSphereRandomized(WorldGenLevel world, BoundingBox box, BlockPos center, float radius, RandomSource rand, float chance, BlockStateRandomizer blockSelector, boolean replaceOnlyAir) {
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                for (float y = -radius; y <= radius; y += 1.0f) {
                    if (!(x * x + y * y + z * z < radius * radius) || replaceOnlyAir && !this.getBlock((BlockGetter)world, (int)x + center.getX(), (int)y + center.getY(), (int)z + center.getZ(), box).isAir() || !(rand.nextFloat() < chance)) continue;
                    this.placeBlock(world, blockSelector.get(rand), (int)x + center.getX(), (int)y + center.getY(), (int)z + center.getZ(), box);
                }
            }
        }
    }

    protected void placeSphereRandomized(WorldGenLevel world, BoundingBox box, int centerX, int centerY, int centerZ, float radius, RandomSource rand, float chance, BlockStateRandomizer blockSelector, boolean replaceOnlyAir) {
        this.placeSphereRandomized(world, box, new BlockPos(centerX, centerY, centerZ), radius, rand, chance, blockSelector, replaceOnlyAir);
    }

    protected void setBlockState(WorldGenLevel worldIn, RandomSource random, BlockStateRandomizer selector, int x, int y, int z, BoundingBox boundingboxIn) {
        BlockState blockState = selector.get(random);
        this.placeBlock(worldIn, blockState, x, y, z, boundingboxIn);
    }

    protected static BoundingBox getInitialBoundingBox(BlockPos startPos) {
        return new BoundingBox(startPos).inflatedBy(64);
    }
}

