/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record DryingTableRecipe(SizedIngredient input, ItemStack output, int duration) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.input.ingredient());
        return ingredients;
    }

    public boolean matches(RecipeInput container, @NotNull Level level) {
        return this.input.test(container.getItem(0)) && this.duration >= 0;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getIngredientStackCount() {
        return this.input.count();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<DryingTableRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<DryingTableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("input").forGetter(DryingTableRecipe::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(DryingTableRecipe::output), (App)Codec.INT.fieldOf("duration").forGetter(DryingTableRecipe::duration)).apply((Applicative)instance, Serializer::createDryingTableRecipe));
        private static final StreamCodec<RegistryFriendlyByteBuf, DryingTableRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<DryingTableRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DryingTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DryingTableRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient input = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int duration = buffer.readInt();
            return new DryingTableRecipe(input, output, duration);
        }

        private static void write(RegistryFriendlyByteBuf buffer, DryingTableRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.duration);
        }

        static DryingTableRecipe createDryingTableRecipe(SizedIngredient input, ItemStack output, int duration) {
            return new DryingTableRecipe(input, output, duration);
        }
    }

    public static class Type
    implements RecipeType<DryingTableRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

