/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ClocheRecipe(Ingredient seed, Ingredient catalyst, Ingredient soil, ItemStack mainOutput, ItemStack chanceOutput1, double chanceOutputChance1, ItemStack chanceOutput2, double chanceOutputChance2, ItemStack chanceOutput3, double chanceOutputChance3, double durationModifier) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.seed);
        return ingredients;
    }

    public boolean matches(RecipeInput container, @NotNull Level level) {
        boolean needCatalyst;
        boolean containsCatalystInSlot = !container.getItem(2).isEmpty();
        boolean bl = needCatalyst = !this.catalyst.isEmpty();
        if (containsCatalystInSlot) {
            if (this.catalyst.test(container.getItem(2))) {
                return this.seed.test(container.getItem(0)) && this.soil.test(container.getItem(1));
            }
            return false;
        }
        return this.seed.test(container.getItem(0)) && this.soil.test(container.getItem(1));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ClocheRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<ClocheRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("seed").forGetter(ClocheRecipe::seed), (App)Ingredient.CODEC.fieldOf("catalyst").orElse((Object)Ingredient.EMPTY).forGetter(ClocheRecipe::catalyst), (App)Ingredient.CODEC.fieldOf("soil").forGetter(ClocheRecipe::soil), (App)ItemStack.CODEC.fieldOf("mainOutput").forGetter(ClocheRecipe::mainOutput), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("chanceOutput1", (Object)ItemStack.EMPTY).forGetter(ClocheRecipe::chanceOutput1), (App)Codec.DOUBLE.optionalFieldOf("chanceOutputChance1", (Object)0.0).orElse((Object)0.0).forGetter(ClocheRecipe::chanceOutputChance1), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("chanceOutput2", (Object)ItemStack.EMPTY).forGetter(ClocheRecipe::chanceOutput2), (App)Codec.DOUBLE.optionalFieldOf("chanceOutputChance2", (Object)0.0).forGetter(ClocheRecipe::chanceOutputChance2), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("chanceOutput3", (Object)ItemStack.EMPTY).forGetter(ClocheRecipe::chanceOutput3), (App)Codec.DOUBLE.optionalFieldOf("chanceOutputChance3", (Object)0.0).forGetter(ClocheRecipe::chanceOutputChance3), (App)Codec.DOUBLE.fieldOf("durationModifier").forGetter(ClocheRecipe::durationModifier)).apply((Applicative)instance, Serializer::createClocheRecipe));
        private final StreamCodec<RegistryFriendlyByteBuf, ClocheRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<ClocheRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ClocheRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static ClocheRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient seed = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient catalyst = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient soil = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack mainOutput = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack chanceOutput1 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            double chanceOutputChance1 = buffer.readDouble();
            ItemStack chanceOutput2 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            double chanceOutputChance2 = buffer.readDouble();
            ItemStack chanceOutput3 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            double chanceOutputChance3 = buffer.readDouble();
            double durationModifier = buffer.readDouble();
            return new ClocheRecipe(seed, catalyst, soil, mainOutput, chanceOutput1, chanceOutputChance1, chanceOutput2, chanceOutputChance2, chanceOutput3, chanceOutputChance3, durationModifier);
        }

        private static void write(RegistryFriendlyByteBuf buffer, ClocheRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.seed);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.catalyst);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.soil);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.mainOutput);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.chanceOutput1);
            buffer.writeDouble(recipe.chanceOutputChance1);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.chanceOutput2);
            buffer.writeDouble(recipe.chanceOutputChance2);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.chanceOutput3);
            buffer.writeDouble(recipe.chanceOutputChance3);
            buffer.writeDouble(recipe.durationModifier);
        }

        private static ClocheRecipe createClocheRecipe(Ingredient input, Ingredient catalyst, Ingredient soil, ItemStack mainOutput, ItemStack chanceOutput1, double chanceOutputChance1, ItemStack chanceOutput2, double chanceOutputChance2, ItemStack chanceOutput3, double chanceOutputChance3, double durationModifier) {
            return new ClocheRecipe(input, catalyst, soil, mainOutput, chanceOutput1, chanceOutputChance1, chanceOutput2, chanceOutputChance2, chanceOutput3, chanceOutputChance3, durationModifier);
        }
    }

    public static class Type
    implements RecipeType<ClocheRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

