/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.networking.packets;

import com.benbenlaw.opolisutilities.block.entity.custom.BlockPlacerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.CrafterBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.EnderScramblerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.RedstoneClockBlockEntity;
import com.benbenlaw.opolisutilities.config.StartupBlockConfigFile;
import com.benbenlaw.opolisutilities.networking.payload.IncreaseTickButtonPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketIncreaseTickButton() {
    public static final PacketIncreaseTickButton INSTANCE = new PacketIncreaseTickButton();

    public static PacketIncreaseTickButton get() {
        return INSTANCE;
    }

    public void handle(IncreaseTickButtonPayload payload, IPayloadContext context) {
        int increment;
        int increment2;
        int timer;
        Player player = context.player();
        Level level = player.level();
        BlockPos blockPos = payload.blockPos();
        boolean isShiftDown = payload.isShiftDown();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BlockPlacerBlockEntity) {
            BlockPlacerBlockEntity blockPlacerBlockEntity = (BlockPlacerBlockEntity)blockEntity;
            timer = blockPlacerBlockEntity.maxProgress;
            int n = increment2 = isShiftDown ? 50 : 10;
            if (increment2 + timer < 2000) {
                blockPlacerBlockEntity.maxProgress = timer + increment2;
            }
        }
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)blockEntity;
            timer = crafterBlockEntity.maxProgress;
            int n = increment2 = isShiftDown ? 50 : 10;
            if (increment2 + timer < 1200) {
                crafterBlockEntity.maxProgress = timer + increment2;
            }
        }
        if (blockEntity instanceof RedstoneClockBlockEntity) {
            int timer2;
            RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockEntity;
            increment = isShiftDown ? 50 : 10;
            if (increment + (timer2 = redstoneClockBlockEntity.maxProgress) < 1200) {
                redstoneClockBlockEntity.maxProgress = timer2 + increment;
                RedstoneClockBlockEntity entity = (RedstoneClockBlockEntity)level.getBlockEntity(blockPos);
                assert (entity != null);
                entity.maxProgress = timer2 + increment;
                entity.progress = 0;
            }
        }
        if (blockEntity instanceof EnderScramblerBlockEntity) {
            int maxRange;
            EnderScramblerBlockEntity enderScramblerBlockEntity = (EnderScramblerBlockEntity)blockEntity;
            int range = enderScramblerBlockEntity.SCRAMBLER_RANGE;
            increment = isShiftDown ? 3 : 1;
            if (range + increment > (maxRange = ((Integer)StartupBlockConfigFile.maxScramblerRange.get()).intValue())) {
                increment = maxRange - range;
            }
            if (range < maxRange) {
                enderScramblerBlockEntity.SCRAMBLER_RANGE = range + increment;
            }
        }
    }
}

