/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.networking.packets;

import com.benbenlaw.opolisutilities.block.entity.custom.BlockPlacerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.CrafterBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.EnderScramblerBlockEntity;
import com.benbenlaw.opolisutilities.block.entity.custom.RedstoneClockBlockEntity;
import com.benbenlaw.opolisutilities.networking.payload.DecreaseTickButtonPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketDecreaseTickButton() {
    public static final PacketDecreaseTickButton INSTANCE = new PacketDecreaseTickButton();

    public static PacketDecreaseTickButton get() {
        return INSTANCE;
    }

    public void handle(DecreaseTickButtonPayload payload, IPayloadContext context) {
        int increment;
        int timer;
        Player player = context.player();
        Level level = player.level();
        BlockPos blockPos = payload.blockPos();
        BlockState blockState = level.getBlockState(blockPos);
        boolean isShiftDown = payload.isShiftDown();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BlockPlacerBlockEntity) {
            BlockPlacerBlockEntity blockPlacerBlockEntity = (BlockPlacerBlockEntity)blockEntity;
            timer = blockPlacerBlockEntity.maxProgress;
            increment = isShiftDown ? 50 : 10;
            if (timer - increment > 50) {
                blockPlacerBlockEntity.maxProgress = timer - increment;
            }
        }
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)blockEntity;
            timer = crafterBlockEntity.maxProgress;
            increment = isShiftDown ? 50 : 10;
            if (timer - increment > 50) {
                crafterBlockEntity.maxProgress = timer - increment;
            }
        }
        if (blockEntity instanceof RedstoneClockBlockEntity) {
            RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockEntity;
            timer = redstoneClockBlockEntity.maxProgress;
            increment = isShiftDown ? 50 : 10;
            if (timer - increment > 50) {
                redstoneClockBlockEntity.maxProgress = timer - increment;
                RedstoneClockBlockEntity entity = (RedstoneClockBlockEntity)level.getBlockEntity(blockPos);
                assert (entity != null);
                entity.maxProgress = timer - increment;
                entity.progress = 0;
            }
        }
        if (blockEntity instanceof EnderScramblerBlockEntity) {
            int minRange;
            EnderScramblerBlockEntity enderScramblerBlockEntity = (EnderScramblerBlockEntity)blockEntity;
            int range = enderScramblerBlockEntity.SCRAMBLER_RANGE;
            increment = isShiftDown ? 3 : 1;
            if (range - increment < (minRange = 1)) {
                increment = range - minRange;
            }
            if (range > minRange) {
                enderScramblerBlockEntity.SCRAMBLER_RANGE = range - increment;
            }
        }
    }
}

