/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.core.block.colored.ColoredLeaves;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.item.colored.ColoredBlockItem;
import com.benbenlaw.core.item.colored.ColoredItem;
import com.benbenlaw.opolisutilities.config.StartupItemConfigFile;
import com.benbenlaw.opolisutilities.item.ModItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CrookItem
extends Item {
    public CrookItem(Item.Properties properties) {
        super(properties);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, BlockState state, @NotNull BlockPos blockPos, @NotNull LivingEntity entity) {
        if (state.getBlock() instanceof LeavesBlock || state.is(BlockTags.LEAVES)) {
            DyeColor color = null;
            if (state.getBlock() instanceof IColored) {
                color = (DyeColor)state.getValue((Property)ColoredLeaves.COLOR);
            }
            for (int i = 0; i < (Integer)StartupItemConfigFile.crookBoost.get(); ++i) {
                List blockDrops = Block.getDrops((BlockState)state.getBlock().defaultBlockState(), (ServerLevel)((ServerLevel)level), (BlockPos)blockPos, (BlockEntity)level.getBlockEntity(blockPos), null, (ItemStack)((Item)ModItems.CROOK.get()).getDefaultInstance());
                for (ItemStack drop : blockDrops) {
                    if (drop.getItem() instanceof ColoredBlockItem || drop.getItem() instanceof ColoredItem) {
                        assert (color != null);
                        drop.set((Supplier)CoreDataComponents.COLOR, (Object)color.toString());
                        drop.set((Supplier)CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)ColoredLeaves.LIT)));
                    }
                    CrookItem.spawnBlockAsEntity(level, blockPos, drop);
                }
            }
            if (entity instanceof Player && ((Boolean)StartupItemConfigFile.crookTakesDamage.get()).booleanValue()) {
                entity.getItemBySlot(EquipmentSlot.MAINHAND).hurtAndBreak(1, entity, entity.getEquipmentSlotForItem(stack));
            }
        }
        return super.mineBlock(stack, level, state, blockPos, entity);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.getBlock() instanceof LeavesBlock || state.is(BlockTags.LEAVES)) {
            return 10.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    private static void spawnBlockAsEntity(Level level, BlockPos pos, ItemStack stack) {
        ItemEntity itemAsEntity = new ItemEntity(level, (double)level.random.nextFloat() * 0.1 + 0.5 + (double)pos.getX(), (double)level.random.nextFloat() * 0.1 + 0.5 + (double)pos.getY(), (double)level.random.nextFloat() * 0.1 + 0.5 + (double)pos.getZ(), stack);
        itemAsEntity.setDefaultPickUpDelay();
        itemAsEntity.setDeltaMovement((double)level.random.nextFloat() * 0.1 - 0.05, (double)level.random.nextFloat() * 0.1 - 0.03, (double)level.random.nextFloat() * 0.1 - 0.05);
        level.addFreshEntity((Entity)itemAsEntity);
    }
}

