/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.integration.jei.OpolisIRecipeSlotTooltipCallback;
import com.benbenlaw.opolisutilities.recipe.ClocheRecipe;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClocheRecipeCategory
implements IRecipeCategory<ClocheRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"cloche");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/jei_cloche.png");
    static final RecipeType<ClocheRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"cloche", ClocheRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    @Nullable
    public ResourceLocation getRegistryName(ClocheRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ClocheRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((ClocheRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public ClocheRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 55);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CLOCHE.get()));
    }

    public RecipeType<ClocheRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.CLOCHE;
    }

    public Component getTitle() {
        return Component.literal((String)"Cloche");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, final ClocheRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addIngredients(recipe.seed());
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 20).addIngredients(recipe.soil());
        if (!recipe.catalyst().hasNoItems()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 4, 38).addIngredients(recipe.catalyst())).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, -1, -1);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 20).addItemStack(new ItemStack((ItemLike)recipe.mainOutput().getItem(), recipe.mainOutput().getCount()));
        if (recipe.chanceOutput1().getItem() != Items.AIR) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 20).addItemStack(new ItemStack((ItemLike)recipe.chanceOutput1().getItem(), recipe.chanceOutput1().getCount()))).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, -1, -1);
        }
        if (recipe.chanceOutput2().getItem() != Items.AIR) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 20).addItemStack(new ItemStack((ItemLike)recipe.chanceOutput2().getItem(), recipe.chanceOutput2().getCount()))).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, -1, -1);
        }
        if (recipe.chanceOutput3().getItem() != Items.AIR) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 121, 20).addItemStack(new ItemStack((ItemLike)recipe.chanceOutput3().getItem(), recipe.chanceOutput3().getCount()))).addTooltipCallback((IRecipeSlotTooltipCallback)new OpolisIRecipeSlotTooltipCallback(this){

                @Override
                public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltipBuilder) {
                    tooltipBuilder.add((FormattedText)Component.literal((String)("Chance: " + recipe.chanceOutputChance3() * 100.0 + "%")));
                }
            }).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, -1, -1);
        }
    }

    public void draw(ClocheRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        int[][] slotAreas = new int[][]{{67, 20, 16, 16}, {85, 20, 16, 16}, {103, 20, 16, 16}, {121, 20, 16, 16}};
        double[] chance = new double[]{1.0, recipe.chanceOutputChance1(), recipe.chanceOutputChance2(), recipe.chanceOutputChance3()};
        for (int i = 0; i < slotAreas.length; ++i) {
            int[] area = slotAreas[i];
            int slotX = area[0];
            int slotY = area[1];
            int slotWidth = area[2];
            int slotHeight = area[3];
            Object chanceText = "Chance: ";
            if (mouseX >= (double)slotX && mouseX < (double)(slotX + slotWidth) && mouseY >= (double)slotY && mouseY < (double)(slotY + slotHeight) && chance[i] > 0.0) {
                chanceText = (String)chanceText + chance[i] * 100.0 + "%";
            }
            guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)chanceText), 30, 2, Color.WHITE.getRGB());
        }
        int finalDuration = (int)(220.0 * recipe.durationModifier());
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)String.valueOf(finalDuration)), 38, 40, Color.WHITE.getRGB());
    }
}

