/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.core.block.UnbreakableResourceBlock;
import com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.screen.custom.BlockBreakerMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBreakerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            BlockBreakerBlockEntity.this.setChanged();
            BlockBreakerBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot == 1 || slot == 2) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }
    };
    private FakePlayer fakePlayer;
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 0;
    private static final int INPUT_SLOT = 0;
    private final IItemHandler blockBreakerItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> false);
    int playingSound = 0;

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.blockBreakerItemHandler;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public BlockBreakerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BLOCK_BREAKER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> BlockBreakerBlockEntity.this.progress;
                    case 1 -> BlockBreakerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        BlockBreakerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        BlockBreakerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = this.createFakePlayer(serverLevel);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.opolisutilities.block_breaker");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new BlockBreakerMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    private static void spawnBlockAsEntity(Level level, BlockPos pos, ItemStack stack) {
        if (!level.isClientSide && !stack.isEmpty()) {
            level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS);
        }
        ItemEntity itemAsEntity = new ItemEntity(level, (double)level.random.nextFloat() * 0.1 + 0.5 + (double)pos.getX(), (double)level.random.nextFloat() * 0.1 + 0.5 + (double)pos.getY(), (double)level.random.nextFloat() * 0.1 + 0.5 + (double)pos.getZ(), stack);
        itemAsEntity.setDefaultPickUpDelay();
        itemAsEntity.setDeltaMovement((double)level.random.nextFloat() * 0.1 - 0.05, (double)level.random.nextFloat() * 0.1 - 0.03, (double)level.random.nextFloat() * 0.1 - 0.05);
        level.addFreshEntity((Entity)itemAsEntity);
    }

    public void tick() {
        Level level = this.level;
        BlockPos pos = this.worldPosition;
        assert (level != null);
        BlockState blockState = level.getBlockState(pos);
        if (!(blockState.isAir() || blockState.is(Blocks.VOID_AIR) || level.isClientSide())) {
            this.sync();
            if (this.fakePlayer == null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.fakePlayer = this.createFakePlayer(serverLevel);
            }
            if (blockState.hasProperty((Property)BlockBreakerBlock.FACING) && ((Boolean)blockState.getValue((Property)BlockBreakerBlock.POWERED)).booleanValue()) {
                Direction direction = (Direction)blockState.getValue((Property)BlockBreakerBlock.FACING);
                BlockPos placeHere = pos.relative(direction);
                Block block = this.level.getBlockState(placeHere).getBlock();
                ItemStack tool = this.itemHandler.getStackInSlot(0);
                int damageValue = this.itemHandler.getStackInSlot(0).getDamageValue();
                List<ItemStack> blockDrops = BlockBreakerBlockEntity.getBlockDrops(this.level, placeHere);
                boolean blockRequiresCorrectTool = block.defaultBlockState().requiresCorrectToolForDrops();
                boolean hasCorrectTool = tool.isCorrectToolForDrops(block.defaultBlockState());
                if (level.getBlockState(placeHere).getBlock() != Blocks.AIR && !blockState.is(Blocks.VOID_AIR) && !blockState.isAir()) {
                    if (!blockRequiresCorrectTool || hasCorrectTool) {
                        float baseToolSpeed;
                        float destroySpeed = block.defaultBlockState().getDestroySpeed((BlockGetter)level, placeHere);
                        Item item = tool.getItem();
                        if (item instanceof TieredItem) {
                            TieredItem tier = (TieredItem)item;
                            baseToolSpeed = tier.getTier().getSpeed();
                        } else {
                            baseToolSpeed = 0.0f;
                        }
                        this.maxProgress = (int)(destroySpeed * (20.0f - baseToolSpeed));
                        int efficiencyLevel = tool.getEnchantmentLevel((Holder)this.level.registryAccess().asGetterLookup().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.EFFICIENCY));
                        if (efficiencyLevel > 0) {
                            if (efficiencyLevel == 1) {
                                this.maxProgress = (int)((float)this.maxProgress * 0.75f);
                            }
                            if (efficiencyLevel == 2) {
                                this.maxProgress = (int)((float)this.maxProgress * 0.7f);
                            }
                            if (efficiencyLevel == 3) {
                                this.maxProgress = (int)((float)this.maxProgress * 0.65f);
                            }
                            if (efficiencyLevel == 4) {
                                this.maxProgress = (int)((float)this.maxProgress * 0.6f);
                            }
                            if (efficiencyLevel == 5) {
                                this.maxProgress = (int)((float)this.maxProgress * 0.55f);
                            }
                        }
                        this.playBreakingSound(level, placeHere);
                        ++this.progress;
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            if (this.itemHandler.getStackInSlot(1).is((Item)Item.BY_BLOCK.get(block)) && this.itemHandler.getStackInSlot(2).isEmpty()) {
                                block.playerDestroy(level, (Player)this.fakePlayer, placeHere, level.getBlockState(placeHere), level.getBlockEntity(placeHere), tool);
                                if (block instanceof UnbreakableResourceBlock) {
                                    return;
                                }
                                level.setBlockAndUpdate(placeHere, Blocks.AIR.defaultBlockState());
                                if (tool.isDamageableItem()) {
                                    this.itemHandler.getStackInSlot(0).hurtAndBreak(1, (LivingEntity)this.fakePlayer, this.fakePlayer.getEquipmentSlotForItem(tool));
                                    this.playBrokenSound(level, placeHere);
                                }
                                if (damageValue + 1 == tool.getMaxDamage()) {
                                    this.itemHandler.extractItem(0, 1, false);
                                    level.playSound(null, placeHere, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                                }
                            } else if (!this.itemHandler.getStackInSlot(2).is((Item)Item.BY_BLOCK.get(block)) && this.itemHandler.getStackInSlot(1).isEmpty()) {
                                block.playerDestroy(level, (Player)this.fakePlayer, placeHere, level.getBlockState(placeHere), level.getBlockEntity(placeHere), tool);
                                if (block instanceof UnbreakableResourceBlock) {
                                    return;
                                }
                                level.setBlockAndUpdate(placeHere, Blocks.AIR.defaultBlockState());
                                if (tool.isDamageableItem()) {
                                    this.itemHandler.getStackInSlot(0).hurtAndBreak(1, (LivingEntity)this.fakePlayer, this.fakePlayer.getEquipmentSlotForItem(tool));
                                    this.playBrokenSound(level, placeHere);
                                }
                                if (damageValue + 1 == tool.getMaxDamage()) {
                                    this.itemHandler.extractItem(0, 1, false);
                                    level.playSound(null, placeHere, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                                }
                            } else if (this.itemHandler.getStackInSlot(1).isEmpty() && this.itemHandler.getStackInSlot(2).isEmpty()) {
                                block.playerDestroy(level, (Player)this.fakePlayer, placeHere, level.getBlockState(placeHere), level.getBlockEntity(placeHere), tool);
                                if (block instanceof UnbreakableResourceBlock) {
                                    return;
                                }
                                level.setBlockAndUpdate(placeHere, Blocks.AIR.defaultBlockState());
                                if (tool.isDamageableItem()) {
                                    this.itemHandler.getStackInSlot(0).hurtAndBreak(1, (LivingEntity)this.fakePlayer, this.fakePlayer.getEquipmentSlotForItem(tool));
                                    this.playBrokenSound(level, placeHere);
                                }
                                if (damageValue + 1 == tool.getMaxDamage()) {
                                    this.itemHandler.extractItem(0, 1, false);
                                    level.playSound(null, placeHere, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                                }
                            }
                        }
                    } else {
                        this.progress = 0;
                        this.maxProgress = 0;
                        this.sync();
                    }
                }
            }
        }
        if (!this.level.isClientSide()) {
            this.setChanged();
            this.sync();
        }
    }

    private float getBreakingSpeed(ItemStack tool, Block block, BlockPos pos) {
        int efficiencyLevel;
        assert (this.level != null);
        BlockState state = block.defaultBlockState();
        float baseSpeed = tool.getDestroySpeed(state);
        if (baseSpeed > 1.0f && (efficiencyLevel = tool.getEnchantmentLevel((Holder)this.level.registryAccess().asGetterLookup().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.EFFICIENCY))) > 0) {
            baseSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
        }
        return baseSpeed;
    }

    private void playBreakingSound(Level level, BlockPos blockPos) {
        ++this.playingSound;
        if (this.playingSound / 10 == 1) {
            SoundType blockSound = level.getBlockState(blockPos).getSoundType((LevelReader)level, blockPos, null);
            level.playSound(null, blockPos, blockSound.getHitSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.playingSound = 0;
        }
    }

    private void playBrokenSound(Level level, BlockPos blockPos) {
        SoundType blockSound = level.getBlockState(blockPos).getSoundType((LevelReader)level, blockPos, null);
        level.playSound(null, blockPos, blockSound.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private FakePlayer createFakePlayer(ServerLevel level) {
        return new FakePlayer(level, new GameProfile(UUID.randomUUID(), "BlockBreaker"));
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos pos) {
        return BlockBreakerBlockEntity.getBlockDrops(world, pos, 0);
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos pos, int fortune) {
        BlockState state = world.getBlockState(pos);
        NonNullList stacks = NonNullList.create();
        stacks.addAll((Collection)Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos)));
        return stacks;
    }
}

