/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.storage.IOPortBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import com.glodblock.github.glodium.util.GlodUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TileExIOPort
extends IOPortBlockEntity {
    private final AppEngInternalInventory inputCells = Ae2Reflect.getInputCellInv(this);
    private static final int NUMBER_OF_CELL_SLOTS = 6;

    public TileExIOPort(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileExIOPort.class, TileExIOPort::new, (Block)EAESingletons.EX_IO_PORT), pos, blockState);
        Ae2Reflect.setIOPortUpgrade(this, UpgradeInventories.forMachine((ItemLike)EAESingletons.EX_IO_PORT, (int)5, () -> ((TileExIOPort)this).saveChanges()));
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.getMainNode().isActive()) {
            return TickRateModulation.IDLE;
        }
        TickRateModulation ret = TickRateModulation.SLEEP;
        long itemsToMove = 2048L;
        switch (this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)) {
            case 1: {
                itemsToMove *= 2L;
                break;
            }
            case 2: {
                itemsToMove *= 4L;
                break;
            }
            case 3: {
                itemsToMove *= 8L;
                break;
            }
            case 4: {
                itemsToMove *= 16L;
                break;
            }
            case 5: {
                itemsToMove *= 32L;
            }
        }
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return TickRateModulation.IDLE;
        }
        for (int x = 0; x < 6; ++x) {
            ItemStack cell = this.inputCells.getStackInSlot(x);
            StorageCell cellInv = StorageCells.getCellInventory((ItemStack)cell, null);
            if (cellInv == null) {
                Ae2Reflect.moveSlotInCell(this, x);
                continue;
            }
            if (itemsToMove > 0L) {
                ret = (itemsToMove = Ae2Reflect.transferItemsFromCell(this, grid, cellInv, itemsToMove)) > 0L ? TickRateModulation.IDLE : TickRateModulation.URGENT;
            }
            if (itemsToMove <= 0L || !this.matchesFullnessMode(cellInv) || !Ae2Reflect.moveSlotInCell(this, x)) continue;
            ret = TickRateModulation.URGENT;
        }
        return ret;
    }
}

