/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.client.gui.subgui.SetAmount;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.container.ContainerPreciseStorageBus;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class GuiPreciseStorageBus
extends UpgradeableScreen<ContainerPreciseStorageBus> {
    private final SettingToggleButton<AccessRestriction> rwMode;
    private final SettingToggleButton<StorageFilter> storageFilter;
    private final SettingToggleButton<YesNo> filterOnExtract;

    public GuiPreciseStorageBus(ContainerPreciseStorageBus menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.widgets.addOpenPriorityButton();
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.CLOSE, btn -> menu.clear()));
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.COG, btn -> menu.partition()));
        this.rwMode = new ServerSettingToggleButton(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        this.filterOnExtract = new ServerSettingToggleButton(Settings.FILTER_ON_EXTRACT, (Enum)YesNo.YES);
        this.addToLeftToolbar((Button)this.storageFilter);
        this.addToLeftToolbar((Button)this.filterOnExtract);
        this.addToLeftToolbar((Button)this.rwMode);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.storageFilter.set((Enum)((ContainerPreciseStorageBus)this.menu).getStorageFilter());
        this.rwMode.set((Enum)((ContainerPreciseStorageBus)this.menu).getReadWriteMode());
        this.filterOnExtract.set((Enum)((ContainerPreciseStorageBus)this.menu).getFilterOnExtract());
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(10.0f, 17.0f, 0.0f);
        poseStack.scale(0.6f, 0.6f, 1.0f);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        if (((ContainerPreciseStorageBus)this.menu).getConnectedTo() != null) {
            guiGraphics.drawString(this.font, (Component)GuiText.AttachedTo.text(new Object[]{((ContainerPreciseStorageBus)this.menu).getConnectedTo()}), 0, 0, color.toARGB(), false);
        } else {
            guiGraphics.drawString(this.font, (Component)GuiText.Unattached.text(), 0, 0, color.toARGB(), false);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.extendedae.precise_export_bus.set_amount"), 0, 13, color.toARGB(), false);
        poseStack.popPose();
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        if (((ContainerPreciseStorageBus)this.menu).getCarried().isEmpty() && this.isValidSlot(this.hoveredSlot)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.getTooltipFromContainerItem(this.hoveredSlot.getItem()));
            GenericStack unwrapped = GenericStack.fromItemStack((ItemStack)this.hoveredSlot.getItem());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.Amount, (GenericStack)unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else {
            super.renderTooltip(guiGraphics, x, y);
        }
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        GenericStack currentStack;
        Slot slot;
        assert (this.minecraft != null);
        if (this.minecraft.options.keyPickItem.matchesMouse(btn) && this.isValidSlot(slot = this.findSlot(xCoord, yCoord)) && (currentStack = GenericStack.fromItemStack((ItemStack)slot.getItem())) != null) {
            SetAmount screen = new SetAmount(this, new ItemStack(EAESingletons.PRECISE_STORAGE_BUS), currentStack, newStack -> PacketDistributor.sendToServer((CustomPacketPayload)new InventoryActionPacket(InventoryAction.SET_FILTER, slot.index, GenericStack.wrapInItemStack((GenericStack)newStack)), (CustomPacketPayload[])new CustomPacketPayload[0]), false);
            this.switchToScreen((AEBaseScreen)screen);
            return true;
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    private boolean isValidSlot(Slot slot) {
        return slot != null && slot.isActive() && slot.hasItem() && ((ContainerPreciseStorageBus)this.menu).isConfigSlot(slot);
    }
}

