/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.GuiText;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.container.ContainerModStorageBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.extendedae.util.FCClientUtil;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiModStorageBus
extends UpgradeableScreen<ContainerModStorageBus>
implements IActionHolder {
    private final ActionMap actions = ActionMap.create();
    private final SettingToggleButton<AccessRestriction> rwMode;
    private final SettingToggleButton<StorageFilter> storageFilter;
    private final SettingToggleButton<YesNo> filterOnExtract;
    private final AETextField filterInputs;

    public GuiModStorageBus(ContainerModStorageBus menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.widgets.addOpenPriorityButton();
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.COG, btn -> menu.partition()));
        this.rwMode = new ServerSettingToggleButton(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        this.filterOnExtract = new ServerSettingToggleButton(Settings.FILTER_ON_EXTRACT, (Enum)YesNo.YES);
        this.addToLeftToolbar((Button)this.storageFilter);
        this.addToLeftToolbar((Button)this.filterOnExtract);
        this.addToLeftToolbar((Button)this.rwMode);
        this.filterInputs = this.widgets.addTextField("filter_input");
        this.filterInputs.setMaxLength(512);
        this.filterInputs.setPlaceholder((Component)Component.translatable((String)"gui.extendedae.mod_storage_bus.tooltip"));
        this.filterInputs.setResponder(s -> {
            this.filterInputs.setSuggestion(FCClientUtil.getModName(s));
            EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", s));
        });
        this.actions.put("init", o -> this.filterInputs.setValue((String)o.get(0)));
        EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("update"));
    }

    public boolean keyPressed(int keyCode, int scanCode, int keyPressed) {
        String suggest;
        if (keyCode == 258 && this.filterInputs.isFocused() && !(suggest = FCClientUtil.getModName(this.filterInputs.getValue())).isEmpty()) {
            this.filterInputs.setValue(this.filterInputs.getValue() + suggest);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, keyPressed);
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.filterInputs.isMouseOver(xCoord, yCoord)) {
            this.filterInputs.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.storageFilter.set((Enum)((ContainerModStorageBus)this.menu).getStorageFilter());
        this.rwMode.set((Enum)((ContainerModStorageBus)this.menu).getReadWriteMode());
        this.filterOnExtract.set((Enum)((ContainerModStorageBus)this.menu).getFilterOnExtract());
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(10.0f, 17.0f, 0.0f);
        poseStack.scale(0.6f, 0.6f, 1.0f);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        if (((ContainerModStorageBus)this.menu).getConnectedTo() != null) {
            guiGraphics.drawString(this.font, (Component)GuiText.AttachedTo.text(new Object[]{((ContainerModStorageBus)this.menu).getConnectedTo()}), 0, 0, color.toARGB(), false);
        } else {
            guiGraphics.drawString(this.font, (Component)GuiText.Unattached.text(), 0, 0, color.toARGB(), false);
        }
        poseStack.popPose();
    }

    protected void init() {
        super.init();
        this.setInitialFocus((GuiEventListener)this.filterInputs);
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

