/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.definitions.AEItems;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.container.ContainerModExportBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.extendedae.util.FCClientUtil;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GuiModExportBus
extends UpgradeableScreen<ContainerModExportBus>
implements IActionHolder {
    private final ActionMap actions = ActionMap.create();
    private final SettingToggleButton<RedstoneMode> redstoneMode = new ServerSettingToggleButton(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
    private final AETextField filterInputs;

    public GuiModExportBus(ContainerModExportBus menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)this.redstoneMode);
        this.filterInputs = this.widgets.addTextField("filter_input");
        this.filterInputs.setMaxLength(512);
        this.filterInputs.setPlaceholder((Component)Component.translatable((String)"gui.extendedae.mod_storage_bus.tooltip"));
        this.filterInputs.setResponder(s -> {
            this.filterInputs.setSuggestion(FCClientUtil.getModName(s));
            EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", s));
        });
        this.actions.put("init", o -> this.filterInputs.setValue((String)o.get(0)));
        EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("update"));
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }

    public boolean keyPressed(int keyCode, int scanCode, int keyPressed) {
        String suggest;
        if (keyCode == 258 && this.filterInputs.isFocused() && !(suggest = FCClientUtil.getModName(this.filterInputs.getValue())).isEmpty()) {
            this.filterInputs.setValue(this.filterInputs.getValue() + suggest);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, keyPressed);
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.filterInputs.isMouseOver(xCoord, yCoord)) {
            this.filterInputs.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set((Enum)((ContainerModExportBus)this.menu).getRedStoneMode());
        this.redstoneMode.setVisibility(((ContainerModExportBus)this.menu).hasUpgrade((ItemLike)AEItems.REDSTONE_CARD));
    }

    protected void init() {
        super.init();
        this.setInitialFocus((GuiEventListener)this.filterInputs);
    }
}

