/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.worldgen;

import com.mynamesraph.mystcraft.mixin.NoiseRouterDataMixin;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a*\u0010\t\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"OverworldNoiseRouter", "Lnet/minecraft/world/level/levelgen/NoiseRouter;", "densityFunctions", "Lnet/minecraft/core/HolderGetter;", "Lnet/minecraft/world/level/levelgen/DensityFunction;", "noiseParameters", "Lnet/minecraft/world/level/levelgen/synth/NormalNoise$NoiseParameters;", "large", "", "flatNoiseRouter", "mystcraft_ageless"})
@SourceDebugExtension(value={"SMAP\nWorldGenHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGenHelper.kt\ncom/mynamesraph/mystcraft/worldgen/WorldGenHelperKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,368:1\n37#2,2:369\n37#2,2:371\n37#2,2:373\n37#2,2:375\n*S KotlinDebug\n*F\n+ 1 WorldGenHelper.kt\ncom/mynamesraph/mystcraft/worldgen/WorldGenHelperKt\n*L\n127#1:369,2\n133#1:371,2\n299#1:373,2\n305#1:375,2\n*E\n"})
public final class WorldGenHelperKt {
    @NotNull
    public static final NoiseRouter OverworldNoiseRouter(@NotNull HolderGetter<DensityFunction> densityFunctions, @NotNull HolderGetter<NormalNoise.NoiseParameters> noiseParameters, boolean large) {
        Intrinsics.checkNotNullParameter(densityFunctions, (String)"densityFunctions");
        Intrinsics.checkNotNullParameter(noiseParameters, (String)"noiseParameters");
        DensityFunction barrier = DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_BARRIER)), (double)0.5);
        DensityFunction fluidLevelFloodedness = DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS)), (double)0.67);
        DensityFunction fluidLevelSpread = DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD)), (double)0.7142857142857143);
        DensityFunction lava = DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_LAVA)));
        DensityFunction shiftX = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getSHIFT_X());
        DensityFunction shiftZ = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getSHIFT_Z());
        DensityFunction temperature = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)((Holder)noiseParameters.getOrThrow(large ? Noises.TEMPERATURE_LARGE : Noises.TEMPERATURE)));
        DensityFunction vegetation = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)((Holder)noiseParameters.getOrThrow(large ? Noises.VEGETATION_LARGE : Noises.VEGETATION)));
        DensityFunction continents = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterData.CONTINENTS_LARGE : NoiseRouterData.CONTINENTS));
        DensityFunction erosion = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterData.EROSION_LARGE : NoiseRouterData.EROSION_LARGE));
        DensityFunction depth = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterDataMixin.getDEPTH_LARGE() : NoiseRouterData.DEPTH));
        DensityFunction ridges = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)NoiseRouterData.RIDGES);
        DensityFunction factor = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterDataMixin.getFACTOR_LARGE() : NoiseRouterData.FACTOR));
        DensityFunction depthGradient = NoiseRouterDataMixin.invokeNoiseGradientDensity(DensityFunctions.cache2d((DensityFunction)factor), depth);
        DensityFunction initialDensity = NoiseRouterDataMixin.invokeSlideOverworld(false, DensityFunctions.add((DensityFunction)depthGradient, (DensityFunction)DensityFunctions.constant((double)-0.703125)).clamp(-64.0, 64.0));
        DensityFunction slopedCheese = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, large ? NoiseRouterDataMixin.getSLOPED_CHEESE_LARGE() : NoiseRouterDataMixin.getSLOPED_CHEESE());
        DensityFunction entrances = DensityFunctions.min((DensityFunction)slopedCheese, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)5.0), (DensityFunction)NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getENTRANCES())));
        DensityFunction underground = DensityFunctions.rangeChoice((DensityFunction)slopedCheese, (double)-1000000.0, (double)1.5625, (DensityFunction)entrances, (DensityFunction)NoiseRouterDataMixin.invokeUnderground(densityFunctions, noiseParameters, slopedCheese));
        DensityFunction finalDensity = DensityFunctions.min((DensityFunction)NoiseRouterDataMixin.invokePostProcess(NoiseRouterDataMixin.invokeSlideOverworld(false, underground)), (DensityFunction)NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getNOODLE()));
        DensityFunction y = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getY());
        OreVeinifier.VeinType[] $this$toTypedArray$iv = (OreVeinifier.VeinType[])EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        OreVeinifier.VeinType[] thisCollection$iv = $this$toTypedArray$iv;
        OreVeinifier.VeinType[] veinTypeArray = thisCollection$iv.toArray(new OreVeinifier.VeinType[0]);
        int minY = Stream.of(Arrays.copyOf(veinTypeArray, veinTypeArray.length)).mapToInt(arg_0 -> WorldGenHelperKt.OverworldNoiseRouter$lambda$1(WorldGenHelperKt::OverworldNoiseRouter$lambda$0, arg_0)).min().orElse(-DimensionType.MIN_Y * 2);
        Collection $this$toTypedArray$iv2 = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        $this$toTypedArray$iv = thisCollection$iv2.toArray(new OreVeinifier.VeinType[0]);
        int maxY = Stream.of(Arrays.copyOf($this$toTypedArray$iv, $this$toTypedArray$iv.length)).mapToInt(arg_0 -> WorldGenHelperKt.OverworldNoiseRouter$lambda$3(WorldGenHelperKt::OverworldNoiseRouter$lambda$2, arg_0)).min().orElse(-DimensionType.MIN_Y * 2);
        DensityFunction veinToggle = NoiseRouterDataMixin.invokeYLimitedInterpolatable(y, DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_VEININESS)), (double)1.5, (double)1.5), minY, maxY, 0);
        DensityFunction oreVeinA = NoiseRouterDataMixin.invokeYLimitedInterpolatable(y, DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_VEIN_A)), (double)4.0, (double)4.0), minY, maxY, 0).abs();
        DensityFunction oreVeinB = NoiseRouterDataMixin.invokeYLimitedInterpolatable(y, DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_VEIN_B)), (double)4.0, (double)4.0), minY, maxY, 0).abs();
        DensityFunction veinRidged = DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.08), (DensityFunction)DensityFunctions.max((DensityFunction)oreVeinA, (DensityFunction)oreVeinB));
        DensityFunction veinGap = DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_GAP)));
        return new NoiseRouter(barrier, fluidLevelFloodedness, fluidLevelSpread, lava, temperature, vegetation, continents, erosion, depth, ridges, initialDensity, finalDensity, veinToggle, veinRidged, veinGap);
    }

    @NotNull
    public static final NoiseRouter flatNoiseRouter(@NotNull HolderGetter<DensityFunction> densityFunctions, @NotNull HolderGetter<NormalNoise.NoiseParameters> noiseParameters, boolean large) {
        Intrinsics.checkNotNullParameter(densityFunctions, (String)"densityFunctions");
        Intrinsics.checkNotNullParameter(noiseParameters, (String)"noiseParameters");
        DensityFunction lava = DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_LAVA)));
        DensityFunction shiftX = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getSHIFT_X());
        DensityFunction shiftZ = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getSHIFT_Z());
        DensityFunction temperature = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)((Holder)noiseParameters.getOrThrow(large ? Noises.TEMPERATURE_LARGE : Noises.TEMPERATURE)));
        DensityFunction vegetation = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)((Holder)noiseParameters.getOrThrow(large ? Noises.VEGETATION_LARGE : Noises.VEGETATION)));
        DensityFunction continents = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterData.CONTINENTS_LARGE : NoiseRouterData.CONTINENTS));
        DensityFunction erosion = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterData.EROSION_LARGE : NoiseRouterData.EROSION_LARGE));
        DensityFunction depth = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterDataMixin.getDEPTH_LARGE() : NoiseRouterData.DEPTH));
        DensityFunction ridges = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)NoiseRouterData.RIDGES);
        DensityFunction factor = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, (ResourceKey<DensityFunction>)(large ? NoiseRouterDataMixin.getFACTOR_LARGE() : NoiseRouterData.FACTOR));
        DensityFunction depthGradient = NoiseRouterDataMixin.invokeNoiseGradientDensity(DensityFunctions.cache2d((DensityFunction)factor), depth);
        DensityFunction initialDensity = NoiseRouterDataMixin.invokeSlideOverworld(false, DensityFunctions.add((DensityFunction)depthGradient, (DensityFunction)DensityFunctions.constant((double)-0.703125)).clamp(-64.0, 64.0));
        DensityFunction slopedCheese = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, large ? NoiseRouterDataMixin.getSLOPED_CHEESE_LARGE() : NoiseRouterDataMixin.getSLOPED_CHEESE());
        DensityFunction entrances = DensityFunctions.min((DensityFunction)slopedCheese, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)5.0), (DensityFunction)NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getENTRANCES())));
        DensityFunction finalDensity = DensityFunctions.min((DensityFunction)NoiseRouterDataMixin.invokePostProcess(NoiseRouterDataMixin.invokeSlideOverworld(false, DensityFunctions.constant((double)64.0))), (DensityFunction)NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getNOODLE()));
        DensityFunction y = NoiseRouterDataMixin.invokeGetFunction(densityFunctions, NoiseRouterDataMixin.getY());
        OreVeinifier.VeinType[] $this$toTypedArray$iv = (OreVeinifier.VeinType[])EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        OreVeinifier.VeinType[] thisCollection$iv = $this$toTypedArray$iv;
        OreVeinifier.VeinType[] veinTypeArray = thisCollection$iv.toArray(new OreVeinifier.VeinType[0]);
        int minY = Stream.of(Arrays.copyOf(veinTypeArray, veinTypeArray.length)).mapToInt(arg_0 -> WorldGenHelperKt.flatNoiseRouter$lambda$5(WorldGenHelperKt::flatNoiseRouter$lambda$4, arg_0)).min().orElse(-DimensionType.MIN_Y * 2);
        Collection $this$toTypedArray$iv2 = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        $this$toTypedArray$iv = thisCollection$iv2.toArray(new OreVeinifier.VeinType[0]);
        int maxY = Stream.of(Arrays.copyOf($this$toTypedArray$iv, $this$toTypedArray$iv.length)).mapToInt(arg_0 -> WorldGenHelperKt.flatNoiseRouter$lambda$7(WorldGenHelperKt::flatNoiseRouter$lambda$6, arg_0)).min().orElse(-DimensionType.MIN_Y * 2);
        DensityFunction veinToggle = NoiseRouterDataMixin.invokeYLimitedInterpolatable(y, DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_VEININESS)), (double)1.5, (double)1.5), minY, maxY, 0);
        DensityFunction oreVeinA = NoiseRouterDataMixin.invokeYLimitedInterpolatable(y, DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_VEIN_A)), (double)4.0, (double)4.0), minY, maxY, 0).abs();
        DensityFunction oreVeinB = NoiseRouterDataMixin.invokeYLimitedInterpolatable(y, DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_VEIN_B)), (double)4.0, (double)4.0), minY, maxY, 0).abs();
        DensityFunction veinRidged = DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.08), (DensityFunction)DensityFunctions.max((DensityFunction)oreVeinA, (DensityFunction)oreVeinB));
        DensityFunction veinGap = DensityFunctions.noise((Holder)((Holder)noiseParameters.getOrThrow(Noises.ORE_GAP)));
        return new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), lava, temperature, vegetation, continents, erosion, depth, ridges, initialDensity, finalDensity, veinToggle, veinRidged, veinGap);
    }

    private static final int OverworldNoiseRouter$lambda$0(OreVeinifier.VeinType it) {
        return it.minY;
    }

    private static final int OverworldNoiseRouter$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int OverworldNoiseRouter$lambda$2(OreVeinifier.VeinType it) {
        return it.maxY;
    }

    private static final int OverworldNoiseRouter$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int flatNoiseRouter$lambda$4(OreVeinifier.VeinType it) {
        return it.minY;
    }

    private static final int flatNoiseRouter$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int flatNoiseRouter$lambda$6(OreVeinifier.VeinType it) {
        return it.maxY;
    }

    private static final int flatNoiseRouter$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<OreVeinifier.VeinType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])OreVeinifier.VeinType.values()));
        }
    }
}

