/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mynamesraph.mystcraft.component.BiomeSymbolsComponent;
import com.mynamesraph.mystcraft.component.DimensionIdentificatorComponent;
import com.mynamesraph.mystcraft.component.LocationComponent;
import com.mynamesraph.mystcraft.component.LocationDisplayComponent;
import com.mynamesraph.mystcraft.component.RotationComponent;
import com.mynamesraph.mystcraft.data.saved.DimensionIdentificatorCounter;
import com.mynamesraph.mystcraft.item.LinkingBookItem;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import com.mynamesraph.mystcraft.worldgen.WorldGenHelperKt;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.random.Random;
import net.commoble.infiniverse.api.InfiniverseAPI;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002J0\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00180\u00172\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"\u00a8\u0006#"}, d2={"Lcom/mynamesraph/mystcraft/item/DescriptiveBookItem;", "Lcom/mynamesraph/mystcraft/item/LinkingBookItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "createSimpleLevel", "Lnet/minecraft/world/level/dimension/LevelStem;", "server", "Lnet/minecraft/server/MinecraftServer;", "createNoiseLevel", "book", "createFlatLevel", "getBiomeList", "", "Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/world/level/biome/Climate$ParameterPoint;", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "create", "Lcom/mynamesraph/mystcraft/data/saved/DimensionIdentificatorCounter;", "load", "tag", "Lnet/minecraft/nbt/CompoundTag;", "lookupProvider", "Lnet/minecraft/core/HolderLookup$Provider;", "mystcraft_ageless"})
public final class DescriptiveBookItem
extends LinkingBookItem {
    public DescriptiveBookItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (!level.isClientSide) {
            MinecraftServer minecraftServer = level.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            DimensionIdentificatorCounter counter = (DimensionIdentificatorCounter)minecraftServer.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(this::create, this::load), DimensionIdentificatorCounter.Companion.getFILE_NAME());
            ItemStack item = player.getItemInHand(usedHand);
            DimensionIdentificatorComponent idComponent = (DimensionIdentificatorComponent)item.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getDIMENSION_ID().get());
            if (idComponent != null && !idComponent.getGenerated()) {
                int n = counter.getId();
                counter.setId(n + 1);
                ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)("age_" + n)));
                counter.setDirty();
                InfiniverseAPI.get().getOrCreateLevel(level.getServer(), levelKey, () -> DescriptiveBookItem.use$lambda$0(this, level, item));
                PatchedDataComponentMap patched = new PatchedDataComponentMap(item.getComponents());
                LocationDisplayComponent display = (LocationDisplayComponent)item.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get());
                if (display != null && display.getName().plainCopy().contains((Component)Component.translatable((String)"mystcraft_ageless.unknown_age"))) {
                    DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get();
                    Object[] objectArray = new Object[]{counter.getId() - 1};
                    MutableComponent mutableComponent = Component.translatable((String)"mystcraft_ageless.age", (Object[])objectArray).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(0xAAAAAA));
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                    patched.set(dataComponentType, (Object)new LocationDisplayComponent((Component)mutableComponent));
                }
                DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getDIMENSION_ID().get();
                ResourceLocation resourceLocation = levelKey.location();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
                patched.set(dataComponentType, (Object)new DimensionIdentificatorComponent(true, resourceLocation));
                Vec3 spawnPos = level.getSharedSpawnPos().getBottomCenter();
                DataComponentType dataComponentType2 = (DataComponentType)MystcraftComponents.INSTANCE.getLOCATION().get();
                Intrinsics.checkNotNull((Object)levelKey);
                patched.set(dataComponentType2, (Object)new LocationComponent((ResourceKey<Level>)levelKey, new Vector3f((float)spawnPos.x, (float)spawnPos.y + 1.0f, (float)spawnPos.z)));
                patched.set((DataComponentType)MystcraftComponents.INSTANCE.getROTATION().get(), (Object)new RotationComponent(0.0f, 0.0f));
                item.applyComponentsAndValidate(patched.asPatch());
            }
        }
        return super.use(level, player, usedHand);
    }

    private final LevelStem createSimpleLevel(MinecraftServer server) {
        ServerLevel oldLevel = server.overworld();
        RegistryOps registryOps = RegistryOps.create((DynamicOps)((DynamicOps)NbtOps.INSTANCE), (HolderLookup.Provider)((HolderLookup.Provider)server.registryAccess()));
        Intrinsics.checkNotNullExpressionValue((Object)registryOps, (String)"create(...)");
        DynamicOps ops = (DynamicOps)registryOps;
        ChunkGenerator oldChunkGenerator = oldLevel.getChunkSource().getGenerator();
        Object object = ChunkGenerator.CODEC.encodeStart(ops, (Object)oldChunkGenerator).flatMap(arg_0 -> DescriptiveBookItem.createSimpleLevel$lambda$2(arg_0 -> DescriptiveBookItem.createSimpleLevel$lambda$1(ops, arg_0), arg_0)).getOrThrow(DescriptiveBookItem::createSimpleLevel$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(...)");
        ChunkGenerator newChunkGenerator = (ChunkGenerator)object;
        Holder holder = oldLevel.dimensionTypeRegistration();
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"dimensionTypeRegistration(...)");
        Holder typeHolder = holder;
        return new LevelStem(typeHolder, newChunkGenerator);
    }

    private final LevelStem createNoiseLevel(MinecraftServer server, ItemStack book) {
        NoiseSettings noiseSettings;
        Holder holder = server.overworld().dimensionTypeRegistration();
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"dimensionTypeRegistration(...)");
        Holder dimensionType = holder;
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(this.getBiomeList(book, server)));
        if (Random.Default.nextInt(0, 10) == 0) {
            var6_5 = NoiseSettings.create((int)64, (int)128, (int)1, (int)1);
            Intrinsics.checkNotNull((Object)var6_5);
            noiseSettings = var6_5;
        } else {
            var6_5 = NoiseSettings.create((int)-64, (int)384, (int)1, (int)2);
            Intrinsics.checkNotNull((Object)var6_5);
            noiseSettings = var6_5;
        }
        NoiseSettings noiseSettings2 = noiseSettings;
        SurfaceRules.RuleSource surfaceRule = switch (Random.Default.nextInt(0, 20)) {
            case 0 -> SurfaceRuleData.nether();
            case 1 -> SurfaceRuleData.end();
            default -> SurfaceRuleData.overworld();
        };
        BlockState fluid = Random.Default.nextInt(0, 100) == 0 ? Blocks.LAVA.defaultBlockState() : Blocks.WATER.defaultBlockState();
        BlockState stone = switch (Random.Default.nextInt(0, 100)) {
            case 0 -> Blocks.ANDESITE.defaultBlockState();
            case 1 -> Blocks.DIORITE.defaultBlockState();
            case 2 -> Blocks.GRANITE.defaultBlockState();
            case 3 -> Blocks.SMOOTH_QUARTZ.defaultBlockState();
            case 4 -> Blocks.DEEPSLATE.defaultBlockState();
            case 5 -> Blocks.ICE.defaultBlockState();
            case 6 -> Blocks.BLACKSTONE.defaultBlockState();
            case 7 -> Blocks.END_STONE.defaultBlockState();
            case 8 -> Blocks.NETHERRACK.defaultBlockState();
            case 9 -> Blocks.TUFF.defaultBlockState();
            case 10 -> Blocks.SANDSTONE.defaultBlockState();
            case 11 -> Blocks.SMOOTH_SANDSTONE.defaultBlockState();
            case 12 -> Blocks.RED_SANDSTONE.defaultBlockState();
            case 13 -> Blocks.SMOOTH_RED_SANDSTONE.defaultBlockState();
            case 14 -> Blocks.PRISMARINE.defaultBlockState();
            case 15 -> Blocks.BASALT.defaultBlockState();
            case 16 -> Blocks.SMOOTH_BASALT.defaultBlockState();
            default -> Blocks.STONE.defaultBlockState();
        };
        int seaLevel = switch (Random.Default.nextInt(0, 100)) {
            case 0 -> 0;
            case 1 -> 128;
            case 2 -> 256;
            default -> 64;
        };
        BiomeSource biomeSource2 = (BiomeSource)biomeSource;
        HolderGetter holderGetter = server.registryAccess().asGetterLookup().lookupOrThrow(Registries.DENSITY_FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)holderGetter, (String)"lookupOrThrow(...)");
        HolderGetter holderGetter2 = server.registryAccess().asGetterLookup().lookupOrThrow(Registries.NOISE);
        Intrinsics.checkNotNullExpressionValue((Object)holderGetter2, (String)"lookupOrThrow(...)");
        NoiseBasedChunkGenerator generator = new NoiseBasedChunkGenerator(biomeSource2, Holder.direct((Object)new NoiseGeneratorSettings(noiseSettings2, stone, fluid, WorldGenHelperKt.OverworldNoiseRouter((HolderGetter<DensityFunction>)holderGetter, (HolderGetter<NormalNoise.NoiseParameters>)holderGetter2, Random.Default.nextBoolean()), surfaceRule, new OverworldBiomeBuilder().spawnTarget(), seaLevel, false, true, true, Random.Default.nextBoolean())));
        return new LevelStem(dimensionType, (ChunkGenerator)generator);
    }

    private final LevelStem createFlatLevel(MinecraftServer server, ItemStack book) {
        Holder holder = server.overworld().dimensionTypeRegistration();
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"dimensionTypeRegistration(...)");
        Holder dimensionType = holder;
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(this.getBiomeList(book, server)));
        NoiseSettings flatNoiseSettings = NoiseSettings.create((int)-64, (int)128, (int)1, (int)2);
        BiomeSource biomeSource2 = (BiomeSource)biomeSource;
        BlockState blockState = Blocks.STONE.defaultBlockState();
        BlockState blockState2 = Blocks.WATER.defaultBlockState();
        HolderGetter holderGetter = server.registryAccess().asGetterLookup().lookupOrThrow(Registries.DENSITY_FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)holderGetter, (String)"lookupOrThrow(...)");
        HolderGetter holderGetter2 = server.registryAccess().asGetterLookup().lookupOrThrow(Registries.NOISE);
        Intrinsics.checkNotNullExpressionValue((Object)holderGetter2, (String)"lookupOrThrow(...)");
        NoiseBasedChunkGenerator generator = new NoiseBasedChunkGenerator(biomeSource2, Holder.direct((Object)new NoiseGeneratorSettings(flatNoiseSettings, blockState, blockState2, WorldGenHelperKt.flatNoiseRouter((HolderGetter<DensityFunction>)holderGetter, (HolderGetter<NormalNoise.NoiseParameters>)holderGetter2, false), SurfaceRuleData.overworld(), new OverworldBiomeBuilder().spawnTarget(), 0, false, false, true, false)));
        return new LevelStem(dimensionType, (ChunkGenerator)generator);
    }

    private final List<Pair<Climate.ParameterPoint, Holder<Biome>>> getBiomeList(ItemStack book, MinecraftServer server) {
        BiomeSymbolsComponent biomeSymbols = (BiomeSymbolsComponent)book.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getBIOME_SYMBOLS().get());
        List biomeList = null;
        if (biomeSymbols != null) {
            List list;
            List $this$getBiomeList_u24lambda_u244 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (ResourceLocation symbol : biomeSymbols.biomes()) {
                Optional optional = server.registryAccess().registryOrThrow(Registries.BIOME).getHolder(symbol);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getHolder(...)");
                Holder.Reference biome = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
                if (biome == null) {
                    LogUtils.getLogger().warn("Found non-existent biome while generating world! Defaulting to plains!");
                    biome = server.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS);
                }
                $this$getBiomeList_u24lambda_u244.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)-2.0f, (float)2.0f), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Random.Default.nextLong(0L, 1L)), (Object)biome));
            }
            biomeList = CollectionsKt.build((List)list);
        } else {
            List list;
            List $this$getBiomeList_u24lambda_u245 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterator iterator = server.registryAccess().registryOrThrow(Registries.BIOME).holders().iterator();
            while (iterator.hasNext()) {
                Holder.Reference biome = (Holder.Reference)iterator.next();
                $this$getBiomeList_u24lambda_u245.add(new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Climate.Parameter.span((float)-2.0f, (float)2.0f), Climate.Parameter.span((float)(-Random.Default.nextFloat()), (float)Random.Default.nextFloat()), Random.Default.nextLong(0L, 1L)), (Object)biome));
            }
            biomeList = CollectionsKt.build((List)list);
        }
        return biomeList;
    }

    @NotNull
    public final DimensionIdentificatorCounter create() {
        return new DimensionIdentificatorCounter();
    }

    @NotNull
    public final DimensionIdentificatorCounter load(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider lookupProvider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        DimensionIdentificatorCounter counter = this.create();
        if (tag.contains("count", 3)) {
            int count = tag.getInt("count");
            counter.setId(count);
        }
        return counter;
    }

    private static final LevelStem use$lambda$0(DescriptiveBookItem this$0, Level $level, ItemStack $item) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        return switch (Random.Default.nextInt(0, 2)) {
            case 0 -> {
                MinecraftServer v0 = $level.getServer();
                Intrinsics.checkNotNull((Object)v0);
                Intrinsics.checkNotNull((Object)$item);
                yield this$0.createNoiseLevel(v0, $item);
            }
            case 1 -> {
                MinecraftServer v2 = $level.getServer();
                Intrinsics.checkNotNull((Object)v2);
                Intrinsics.checkNotNull((Object)$item);
                yield this$0.createFlatLevel(v2, $item);
            }
            default -> {
                MinecraftServer v3 = $level.getServer();
                Intrinsics.checkNotNull((Object)v3);
                yield this$0.createSimpleLevel(v3);
            }
        };
    }

    private static final DataResult createSimpleLevel$lambda$1(DynamicOps $ops, Tag it) {
        Intrinsics.checkNotNullParameter((Object)$ops, (String)"$ops");
        return ChunkGenerator.CODEC.parse($ops, (Object)it);
    }

    private static final DataResult createSimpleLevel$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final RuntimeException createSimpleLevel$lambda$3(String it) {
        return new RuntimeException("Error copying dimension: " + it);
    }
}

