/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.data.datagen;

import com.mynamesraph.mystcraft.data.datagen.block.MystcraftBlockLootTableProvider;
import com.mynamesraph.mystcraft.data.datagen.block.MystcraftBlockStateProvider;
import com.mynamesraph.mystcraft.data.datagen.block.MystcraftBlockTagProvider;
import com.mynamesraph.mystcraft.data.datagen.datapack.MystcraftDatapackProvider;
import com.mynamesraph.mystcraft.data.datagen.item.MystcraftItemModelProvider;
import com.mynamesraph.mystcraft.data.datagen.item.MystcraftItemTagProvider;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="mystcraft_ageless", bus=EventBusSubscriber.Bus.MOD)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/mynamesraph/mystcraft/data/datagen/DataGenerators;", "", "<init>", "()V", "gatherData", "", "event", "Lnet/neoforged/neoforge/data/event/GatherDataEvent;", "mystcraft_ageless"})
public final class DataGenerators {
    @NotNull
    public static final DataGenerators INSTANCE = new DataGenerators();

    private DataGenerators() {
    }

    @SubscribeEvent
    public final void gatherData(@NotNull GatherDataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), CollectionsKt.listOf((Object)new LootTableProvider.SubProviderEntry(MystcraftBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        Intrinsics.checkNotNull((Object)packOutput);
        Intrinsics.checkNotNull((Object)lookupProvider);
        MystcraftBlockTagProvider blockTagProvider = new MystcraftBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        boolean bl = event.includeServer();
        CompletableFuture completableFuture = blockTagProvider.contentsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"contentsGetter(...)");
        Intrinsics.checkNotNull((Object)existingFileHelper);
        generator.addProvider(bl, (DataProvider)new MystcraftItemTagProvider(packOutput, lookupProvider, completableFuture, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MystcraftBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MystcraftItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MystcraftDatapackProvider(packOutput, lookupProvider));
    }
}

