/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.crafting.recipe;

import com.mojang.logging.LogUtils;
import com.mynamesraph.mystcraft.component.LocationComponent;
import com.mynamesraph.mystcraft.component.LocationDisplayComponent;
import com.mynamesraph.mystcraft.component.RotationComponent;
import com.mynamesraph.mystcraft.crafting.input.PlayerCraftingInput;
import com.mynamesraph.mystcraft.crafting.recipe.LocationalShapelessRecipe;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import com.mynamesraph.mystcraft.registry.MystcraftRecipes;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0016J\f\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0016J\b\u0010'\u001a\u00020\u000fH\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/mynamesraph/mystcraft/crafting/recipe/LocationalShapelessRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput;", "result", "Lnet/minecraft/world/item/ItemStack;", "ingredientsList", "", "Lnet/minecraft/world/item/crafting/Ingredient;", "<init>", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;)V", "getResult", "()Lnet/minecraft/world/item/ItemStack;", "getIngredientsList", "()Ljava/util/List;", "isSimple", "", "lazyIngredients", "Lnet/minecraft/core/NonNullList;", "getLazyIngredients", "()Lnet/minecraft/core/NonNullList;", "lazyIngredients$delegate", "Lkotlin/Lazy;", "assemble", "input", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getIngredients", "matches", "level", "Lnet/minecraft/world/level/Level;", "canCraftInDimensions", "width", "", "height", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "isSpecial", "getRemainingItems", "mystcraft_ageless"})
public final class LocationalShapelessRecipe
implements Recipe<PlayerCraftingInput> {
    @NotNull
    private final ItemStack result;
    @NotNull
    private final List<Ingredient> ingredientsList;
    private final boolean isSimple;
    @NotNull
    private final Lazy lazyIngredients$delegate;

    public LocationalShapelessRecipe(@NotNull ItemStack result, @NotNull List<Ingredient> ingredientsList) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(ingredientsList, (String)"ingredientsList");
        this.result = result;
        this.ingredientsList = ingredientsList;
        this.isSimple = this.ingredientsList.stream().allMatch(arg_0 -> LocationalShapelessRecipe.isSimple$lambda$0(isSimple.1.INSTANCE, arg_0));
        this.lazyIngredients$delegate = LazyKt.lazy(() -> LocationalShapelessRecipe.lazyIngredients_delegate$lambda$1(this));
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public final List<Ingredient> getIngredientsList() {
        return this.ingredientsList;
    }

    private final NonNullList<Ingredient> getLazyIngredients() {
        Lazy lazy = this.lazyIngredients$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (NonNullList)object;
    }

    @NotNull
    public ItemStack assemble(@NotNull PlayerCraftingInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack itemStack = this.result.copy();
        PatchedDataComponentMap patchedComponents = new PatchedDataComponentMap(itemStack.getComponents());
        if (patchedComponents.get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION().get()) != null) {
            DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getLOCATION().get();
            Player player = input.getPlayer();
            Intrinsics.checkNotNull((Object)player);
            ResourceKey resourceKey = player.level().dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            patchedComponents.set(dataComponentType, (Object)new LocationComponent((ResourceKey<Level>)resourceKey, new Vector3f((float)input.getPlayer().getX(), (float)input.getPlayer().getY(), (float)input.getPlayer().getZ())));
        } else {
            LogUtils.getLogger().error("Attempted to craft an item that does not have a " + Reflection.getOrCreateKotlinClass(LocationComponent.class).getSimpleName() + " with a " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ".Please add the component as a default component to the item before using this recipe.");
        }
        if (patchedComponents.get((DataComponentType)MystcraftComponents.INSTANCE.getROTATION().get()) != null) {
            DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getROTATION().get();
            Player player = input.getPlayer();
            Intrinsics.checkNotNull((Object)player);
            patchedComponents.set(dataComponentType, (Object)new RotationComponent(player.getXRot(), input.getPlayer().getYRot()));
        } else {
            LogUtils.getLogger().error("Attempted to craft an item that does not have a " + Reflection.getOrCreateKotlinClass(RotationComponent.class).getSimpleName() + " with a " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ".Please add the component as a default component to the item before using this recipe.");
        }
        if (patchedComponents.get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get()) != null) {
            String string;
            String id = "";
            Player player = input.getPlayer();
            Intrinsics.checkNotNull((Object)player);
            String string2 = player.level().dimension().location().toLanguageKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLanguageKey(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"mystcraft_ageless.age_", (boolean)false, (int)2, null)) {
                String string3 = input.getPlayer().level().dimension().location().toLanguageKey();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLanguageKey(...)");
                id = StringsKt.removePrefix((String)string3, (CharSequence)"mystcraft_ageless.age_");
                string = "mystcraft_ageless.age";
            } else {
                string = input.getPlayer().level().dimension().location().toLanguageKey();
            }
            String text = string;
            DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get();
            Object[] objectArray = new Object[]{id};
            MutableComponent mutableComponent = Component.translatable((String)text, (Object[])objectArray).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(0xAAAAAA));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            patchedComponents.set(dataComponentType, (Object)new LocationDisplayComponent((Component)mutableComponent));
        } else {
            LogUtils.getLogger().error("Attempted to craft an item that does not have a " + Reflection.getOrCreateKotlinClass(LocationDisplayComponent.class).getSimpleName() + " with a " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ".Please add the component as a default component to the item before using this recipe.");
        }
        itemStack.applyComponentsAndValidate(patchedComponents.asPatch());
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.getLazyIngredients();
    }

    public boolean matches(@NotNull PlayerCraftingInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (input.getIngredientCount() != this.ingredientsList.size()) {
            return false;
        }
        if (!this.isSimple) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.getIngredientCount());
            for (ItemStack item : input.getItems()) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            return RecipeMatcher.findMatches((List)nonEmptyItems, this.ingredientsList) != null;
        }
        return input.size() == 1 && this.ingredientsList.size() == 1 ? ((Ingredient)CollectionsKt.first(this.ingredientsList)).test(input.getItem(0)) : input.getStackedContents().canCraft((Recipe)this, null);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredientsList.size();
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        RecipeSerializer<LocationalShapelessRecipe> recipeSerializer = MystcraftRecipes.INSTANCE.getLOCATIONAL_SHAPELESS_RECIPE_SERIALIZER().get();
        Intrinsics.checkNotNullExpressionValue(recipeSerializer, (String)"get(...)");
        return recipeSerializer;
    }

    @NotNull
    public RecipeType<?> getType() {
        RecipeType<LocationalShapelessRecipe> recipeType = MystcraftRecipes.INSTANCE.getLOCATIONAL_RECIPE_TYPE().get();
        Intrinsics.checkNotNullExpressionValue(recipeType, (String)"get(...)");
        return recipeType;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull PlayerCraftingInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        NonNullList nonNullList = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        return nonNullList;
    }

    private static final boolean isSimple$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final NonNullList lazyIngredients_delegate$lambda$1(LocationalShapelessRecipe this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        NonNullList list = NonNullList.create();
        for (Ingredient ingredient : this$0.ingredientsList) {
            list.add((Object)ingredient);
        }
        return list;
    }
}

