/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.crafting.input;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u0005H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput;", "Lnet/minecraft/world/item/crafting/RecipeInput;", "player", "Lnet/minecraft/world/entity/player/Player;", "width", "", "height", "items", "", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Lnet/minecraft/world/entity/player/Player;IILjava/util/List;)V", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "getWidth", "()I", "getHeight", "getItems", "()Ljava/util/List;", "stackedContents", "Lnet/minecraft/world/entity/player/StackedContents;", "getStackedContents", "()Lnet/minecraft/world/entity/player/StackedContents;", "ingredientCount", "getIngredientCount", "getItem", "index", "size", "isEmpty", "", "equals", "other", "", "hashCode", "Companion", "mystcraft_ageless"})
public final class PlayerCraftingInput
implements RecipeInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Player player;
    private final int width;
    private final int height;
    @NotNull
    private final List<ItemStack> items;
    @NotNull
    private final StackedContents stackedContents;
    private final int ingredientCount;
    @NotNull
    private static final PlayerCraftingInput EMPTY = new PlayerCraftingInput(null, 0, 0, CollectionsKt.emptyList());

    public PlayerCraftingInput(@Nullable Player player, int width, int height, @NotNull List<ItemStack> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.player = player;
        this.width = width;
        this.height = height;
        this.items = items;
        this.stackedContents = new StackedContents();
        int count = 0;
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            ++count;
            this.stackedContents.accountStack(itemStack, 1);
        }
        this.ingredientCount = count;
    }

    @Nullable
    public final Player getPlayer() {
        return this.player;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final List<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    public final StackedContents getStackedContents() {
        return this.stackedContents;
    }

    public final int getIngredientCount() {
        return this.ingredientCount;
    }

    @NotNull
    public ItemStack getItem(int index) {
        return this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.ingredientCount == 0;
    }

    public boolean equals(@Nullable Object other) {
        return other == this ? true : (!(other instanceof PlayerCraftingInput) ? false : this.width == ((PlayerCraftingInput)other).width && this.height == ((PlayerCraftingInput)other).height && this.ingredientCount == ((PlayerCraftingInput)other).ingredientCount && ItemStack.listMatches(this.items, ((PlayerCraftingInput)other).items));
    }

    public int hashCode() {
        int i = ItemStack.hashStackList(this.items);
        i = 31 * i + this.width;
        return 31 * i + this.height;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J,\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput;", "getEMPTY", "()Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput;", "ofPositioned", "Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput$Companion$Positioned;", "player", "Lnet/minecraft/world/entity/player/Player;", "width", "", "height", "items", "", "Lnet/minecraft/world/item/ItemStack;", "of", "Positioned", "mystcraft_ageless"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlayerCraftingInput getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Positioned ofPositioned(@NotNull Player player, int width, int height, @NotNull List<ItemStack> items) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            if (width != 0 && height != 0) {
                int i = width - 1;
                int j = 0;
                int k = height - 1;
                int l = 0;
                for (int i1 = 0; i1 < height; ++i1) {
                    boolean flag = true;
                    for (int j1 = 0; j1 < width; ++j1) {
                        ItemStack itemStack = items.get(j1 + i1 * width);
                        if (itemStack.isEmpty()) continue;
                        i = (int)Math.min((double)i, (double)j1);
                        j = (int)Math.max((double)j, (double)j1);
                        flag = false;
                    }
                    if (flag) continue;
                    k = (int)Math.min((double)k, (double)i1);
                    l = (int)Math.max((double)l, (double)i1);
                }
                int i2 = j - i + 1;
                int j2 = l - k + 1;
                if (i2 <= 0 || j2 <= 0) {
                    return Positioned.Companion.getEMPTY();
                }
                if (i2 == width && j2 == height) {
                    return new Positioned(new PlayerCraftingInput(player, width, height, items), i, k);
                }
                List list = new ArrayList(i2 * j2);
                for (int k2 = 0; k2 < j2; ++k2) {
                    for (int k1 = 0; k1 < i2; ++k1) {
                        int l1 = k1 + i + (k2 + k) * width;
                        list.add(items.get(l1));
                    }
                }
                return new Positioned(new PlayerCraftingInput(player, i2, j2, list), i, k);
            }
            return Positioned.Companion.getEMPTY();
        }

        @NotNull
        public final PlayerCraftingInput of(@NotNull Player player, int width, int height, @NotNull List<ItemStack> items) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return this.ofPositioned(player, width, height, items).input();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput$Companion$Positioned;", "Ljava/lang/Record;", "input", "Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput;", "left", "", "top", "<init>", "(Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput;II)V", "()Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput;", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "mystcraft_ageless"})
        public static final class Positioned
        extends Record {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final PlayerCraftingInput input;
            private final int left;
            private final int top;
            @NotNull
            private static final Positioned EMPTY = new Positioned(Companion.getEMPTY(), 0, 0);

            public Positioned(@NotNull PlayerCraftingInput input, int left, int top) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                this.input = input;
                this.left = left;
                this.top = top;
            }

            @NotNull
            public final PlayerCraftingInput input() {
                return this.input;
            }

            public final int left() {
                return this.left;
            }

            public final int top() {
                return this.top;
            }

            @NotNull
            public final PlayerCraftingInput component1() {
                return this.input;
            }

            public final int component2() {
                return this.left;
            }

            public final int component3() {
                return this.top;
            }

            @NotNull
            public final Positioned copy(@NotNull PlayerCraftingInput input, int left, int top) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return new Positioned(input, left, top);
            }

            public static /* synthetic */ Positioned copy$default(Positioned positioned, PlayerCraftingInput playerCraftingInput, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    playerCraftingInput = positioned.input;
                }
                if ((n3 & 2) != 0) {
                    n = positioned.left;
                }
                if ((n3 & 4) != 0) {
                    n2 = positioned.top;
                }
                return positioned.copy(playerCraftingInput, n, n2);
            }

            @Override
            @NotNull
            public String toString() {
                return "Positioned(input=" + this.input + ", left=" + this.left + ", top=" + this.top + ")";
            }

            @Override
            public int hashCode() {
                int result = this.input.hashCode();
                result = result * 31 + Integer.hashCode(this.left);
                result = result * 31 + Integer.hashCode(this.top);
                return result;
            }

            @Override
            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Positioned)) {
                    return false;
                }
                Positioned positioned = (Positioned)other;
                if (!Intrinsics.areEqual((Object)this.input, (Object)positioned.input)) {
                    return false;
                }
                if (this.left != positioned.left) {
                    return false;
                }
                return this.top == positioned.top;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput$Companion$Positioned$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput$Companion$Positioned;", "getEMPTY", "()Lcom/mynamesraph/mystcraft/crafting/input/PlayerCraftingInput$Companion$Positioned;", "mystcraft_ageless"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Positioned getEMPTY() {
                    return EMPTY;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

