/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.block.portal;

import com.mynamesraph.mystcraft.block.portal.Counter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a=\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a]\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001aI\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a[\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00020\u00190\u00012\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001aI\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\"\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a8\u0006\""}, d2={"solveFrameCorners", "Lkotlin/Result;", "", "Lnet/minecraft/core/BlockPos;", "origin", "validBlocks", "", "Lnet/minecraft/world/level/block/Block;", "level", "Lnet/minecraft/world/level/Level;", "maxBlockCount", "", "(Lnet/minecraft/core/BlockPos;Ljava/util/Set;Lnet/minecraft/world/level/Level;I)Ljava/lang/Object;", "validateFrameInDirection", "pos", "direction", "Lnet/minecraft/core/Direction;", "corners", "", "counter", "Lcom/mynamesraph/mystcraft/block/portal/Counter;", "(Lnet/minecraft/core/BlockPos;Ljava/util/Set;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Direction;Lnet/minecraft/core/BlockPos;Ljava/util/List;Lcom/mynamesraph/mystcraft/block/portal/Counter;)Ljava/lang/Object;", "findEndOfLine", "(Lnet/minecraft/core/BlockPos;Ljava/util/Set;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Direction;Lnet/minecraft/core/BlockPos;Lcom/mynamesraph/mystcraft/block/portal/Counter;)Ljava/lang/Object;", "findNextBranch", "Lkotlin/Pair;", "isNeighbourValid", "", "findAllValidNeighbours", "notIncluded", "(Lnet/minecraft/core/BlockPos;Ljava/util/Set;Lnet/minecraft/world/level/Level;Ljava/util/Set;)Ljava/lang/Object;", "findAllPointsInsidePolygon", "vertices", "getPolygonBounds", "mystcraft_ageless"})
@SourceDebugExtension(value={"SMAP\nMystcraftPortalSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MystcraftPortalSolver.kt\ncom/mynamesraph/mystcraft/block/portal/MystcraftPortalSolverKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1#2:275\n*E\n"})
public final class MystcraftPortalSolverKt {
    @NotNull
    public static final Object solveFrameCorners(@NotNull BlockPos origin, @NotNull Set<? extends Block> validBlocks, @NotNull Level level, int maxBlockCount) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(validBlocks, (String)"validBlocks");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List allValidCorners = new ArrayList();
        Counter blockCounter = new Counter(maxBlockCount);
        try {
            boolean bl = false;
            Object object = MystcraftPortalSolverKt.findAllValidNeighbours$default(origin, validBlocks, level, null, 8, null);
            ResultKt.throwOnFailure((Object)object);
            for (Direction direction : (List)object) {
                BlockPos blockPos = origin.relative(direction);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
                Object result = MystcraftPortalSolverKt.validateFrameInDirection(blockPos, validBlocks, level, direction, origin, new ArrayList(), blockCounter);
                if (!Result.isSuccess-impl((Object)result)) continue;
                Object object2 = result;
                ResultKt.throwOnFailure((Object)object2);
                List validCorners = (List)object2;
                object2 = result;
                ResultKt.throwOnFailure((Object)object2);
                allValidCorners.addAll((Collection)object2);
            }
            Object object3 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (!((Collection)allValidCorners).isEmpty()) {
            return Result.constructor-impl((Object)CollectionsKt.distinct((Iterable)allValidCorners));
        }
        return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("No valid paths were found")));
    }

    private static final Object validateFrameInDirection(BlockPos pos, Set<? extends Block> validBlocks, Level level, Direction direction, BlockPos origin, List<BlockPos> corners, Counter counter) {
        Iterator branchR = MystcraftPortalSolverKt.findNextBranch(pos, validBlocks, level, direction, origin, counter);
        if (Result.isSuccess-impl((Object)branchR)) {
            Iterator iterator = branchR;
            ResultKt.throwOnFailure((Object)iterator);
            BlockPos branchPos = (BlockPos)((Pair)iterator).getFirst();
            Iterator iterator2 = branchR;
            ResultKt.throwOnFailure((Object)iterator2);
            List branchDirections = (List)((Pair)iterator2).getSecond();
            corners.add(branchPos);
            iterator2 = branchDirections.iterator();
            if (iterator2.hasNext()) {
                Direction branchDirection = (Direction)iterator2.next();
                BlockPos blockPos = branchPos.relative(branchDirection);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
                return MystcraftPortalSolverKt.validateFrameInDirection(blockPos, validBlocks, level, branchDirection, origin, corners, counter);
            }
        } else {
            Throwable throwable = Result.exceptionOrNull-impl((Object)branchR);
            Intrinsics.checkNotNull((Object)throwable);
            String string = throwable.getMessage();
            if (Intrinsics.areEqual((Object)string, (Object)"The origin was encountered")) {
                return Result.constructor-impl(corners);
            }
            if (Intrinsics.areEqual((Object)string, (Object)"The line ends before branching")) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Frame was not valid because no more branches were found")));
            }
        }
        return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException()));
    }

    private static final Object findEndOfLine(BlockPos pos, Set<? extends Block> validBlocks, Level level, Direction direction, BlockPos origin, Counter counter) {
        BlockPos currentPos = pos.relative(direction);
        BlockState bs = level.getBlockState(currentPos);
        System.out.println((Object)("endOfLine: " + bs + " at " + currentPos));
        while (validBlocks.contains(bs.getBlock())) {
            int n = counter.getCount();
            counter.setCount(n + 1);
            if (counter.maxxed()) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Too many blocks!")));
            }
            if (Intrinsics.areEqual((Object)currentPos, (Object)origin)) {
                System.out.println((Object)"endOfLine: Congrats you looped back to the origin");
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("endOfLine: The end of this line could not be reached as the origin block was encountered.")));
            }
            bs = level.getBlockState(currentPos.relative(direction));
            System.out.println((Object)("endOfLine: " + bs + " at " + currentPos));
            if (!validBlocks.contains(bs.getBlock())) continue;
            currentPos = currentPos.relative(direction);
        }
        return Result.constructor-impl((Object)currentPos.relative(direction.getOpposite()));
    }

    private static final Object findNextBranch(BlockPos pos, Set<? extends Block> validBlocks, Level level, Direction direction, BlockPos origin, Counter counter) {
        BlockPos currentPos = pos;
        Object[] objectArray = new Direction[]{direction, direction.getOpposite()};
        Object foundBranch = MystcraftPortalSolverKt.findAllValidNeighbours(currentPos, validBlocks, level, SetsKt.setOf((Object[])objectArray));
        while (Result.isFailure-impl((Object)foundBranch)) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)foundBranch);
            Intrinsics.checkNotNull((Object)throwable);
            if (!Intrinsics.areEqual((Object)throwable.getMessage(), (Object)"No valid neighbours")) {
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)foundBranch);
                Intrinsics.checkNotNull((Object)throwable2);
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            if (Intrinsics.areEqual((Object)currentPos, (Object)origin)) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("The origin was encountered")));
            }
            if (MystcraftPortalSolverKt.isNeighbourValid(currentPos, validBlocks, level, direction)) {
                currentPos = currentPos.relative(direction);
                objectArray = new Direction[]{direction, direction.getOpposite()};
                foundBranch = MystcraftPortalSolverKt.findAllValidNeighbours(currentPos, validBlocks, level, SetsKt.setOf((Object[])objectArray));
                continue;
            }
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("The line ends before branching")));
        }
        Object object = foundBranch;
        ResultKt.throwOnFailure((Object)object);
        return Result.constructor-impl((Object)new Pair((Object)currentPos, object));
    }

    private static final boolean isNeighbourValid(BlockPos pos, Set<? extends Block> validBlocks, Level level, Direction direction) {
        return validBlocks.contains(level.getBlockState(pos.relative(direction)).getBlock());
    }

    private static final Object findAllValidNeighbours(BlockPos pos, Set<? extends Block> validBlocks, Level level, Set<? extends Direction> notIncluded) {
        List validNeighbours = new ArrayList();
        for (Direction direction : EntriesMappings.entries$0) {
            if (notIncluded != null && notIncluded.contains(direction) || !MystcraftPortalSolverKt.isNeighbourValid(pos, validBlocks, level, direction)) continue;
            validNeighbours.add(direction);
        }
        if (validNeighbours.isEmpty()) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("No valid neighbours")));
        }
        return Result.constructor-impl((Object)validNeighbours);
    }

    static /* synthetic */ Object findAllValidNeighbours$default(BlockPos blockPos, Set set, Level level, Set set2, int n, Object object) {
        if ((n & 8) != 0) {
            set2 = null;
        }
        return MystcraftPortalSolverKt.findAllValidNeighbours(blockPos, set, level, set2);
    }

    @NotNull
    public static final List<BlockPos> findAllPointsInsidePolygon(@NotNull List<? extends BlockPos> vertices) {
        Intrinsics.checkNotNullParameter(vertices, (String)"vertices");
        Pair<BlockPos, BlockPos> bounds = MystcraftPortalSolverKt.getPolygonBounds(vertices);
        BlockPos boundMin = (BlockPos)bounds.getFirst();
        BlockPos boundMax = (BlockPos)bounds.getSecond();
        List validPoints = new ArrayList();
        int x = boundMin.getX();
        int n = boundMax.getX();
        if (x <= n) {
            while (true) {
                int n2;
                int y;
                if ((y = boundMin.getY()) <= (n2 = boundMax.getY())) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = boundMin.getZ()) <= (n3 = boundMax.getZ())) {
                            while (true) {
                                validPoints.add(new BlockPos(x, y, z));
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return validPoints;
    }

    private static final Pair<BlockPos, BlockPos> getPolygonBounds(List<? extends BlockPos> vertices) {
        Iterator iterator = ((Iterable)vertices).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        BlockPos it422 = (BlockPos)iterator.next();
        boolean bl = false;
        int it422 = it422.getX();
        while (iterator.hasNext()) {
            BlockPos it32 = (BlockPos)iterator.next();
            $i$a$-minOf-MystcraftPortalSolverKt$getPolygonBounds$minX$1 = false;
            int it32 = it32.getX();
            if (it422 <= it32) continue;
            it422 = it32;
        }
        int minX = it422;
        Iterator it422 = ((Iterable)vertices).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        BlockPos it622 = (BlockPos)it422.next();
        boolean bl2 = false;
        int it622 = it622.getY();
        while (it422.hasNext()) {
            BlockPos it52 = (BlockPos)it422.next();
            $i$a$-minOf-MystcraftPortalSolverKt$getPolygonBounds$minY$1 = false;
            int it52 = it52.getY();
            if (it622 <= it52) continue;
            it622 = it52;
        }
        int minY = it622;
        Iterator it622 = ((Iterable)vertices).iterator();
        if (!it622.hasNext()) {
            throw new NoSuchElementException();
        }
        BlockPos it22 = (BlockPos)it622.next();
        boolean bl3 = false;
        int it22 = it22.getZ();
        while (it622.hasNext()) {
            BlockPos it72 = (BlockPos)it622.next();
            $i$a$-minOf-MystcraftPortalSolverKt$getPolygonBounds$minZ$1 = false;
            int it72 = it72.getZ();
            if (it22 <= it72) continue;
            it22 = it72;
        }
        int minZ = it22;
        BlockPos min = new BlockPos(minX, minY, minZ);
        Iterator it72 = ((Iterable)vertices).iterator();
        if (!it72.hasNext()) {
            throw new NoSuchElementException();
        }
        BlockPos it1022 = (BlockPos)it72.next();
        boolean bl4 = false;
        int it1022 = it1022.getX();
        while (it72.hasNext()) {
            BlockPos it92 = (BlockPos)it72.next();
            $i$a$-maxOf-MystcraftPortalSolverKt$getPolygonBounds$maxX$1 = false;
            int it92 = it92.getX();
            if (it1022 >= it92) continue;
            it1022 = it92;
        }
        int maxX = it1022;
        Iterator it1022 = ((Iterable)vertices).iterator();
        if (!it1022.hasNext()) {
            throw new NoSuchElementException();
        }
        BlockPos it = (BlockPos)it1022.next();
        boolean bl5 = false;
        int n = it.getY();
        while (it1022.hasNext()) {
            BlockPos it82 = (BlockPos)it1022.next();
            $i$a$-maxOf-MystcraftPortalSolverKt$getPolygonBounds$maxY$1 = false;
            int it82 = it82.getY();
            if (n >= it82) continue;
            n = it82;
        }
        int maxY = n;
        Iterator iterator2 = ((Iterable)vertices).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        BlockPos it3 = (BlockPos)iterator2.next();
        boolean bl6 = false;
        int n2 = it3.getZ();
        while (iterator2.hasNext()) {
            BlockPos it5 = (BlockPos)iterator2.next();
            $i$a$-maxOf-MystcraftPortalSolverKt$getPolygonBounds$maxZ$1 = false;
            int n3 = it5.getZ();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        int maxZ = n2;
        BlockPos max = new BlockPos(maxX, maxY, maxZ);
        return new Pair((Object)min, (Object)max);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

