/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.block.portal;

import com.mynamesraph.mystcraft.block.portal.BookReceptacleBlock;
import com.mynamesraph.mystcraft.block.portal.BookReceptacleBlockEntity;
import com.mynamesraph.mystcraft.block.portal.LinkPortalBlockEntity;
import com.mynamesraph.mystcraft.component.LocationComponent;
import com.mynamesraph.mystcraft.component.RotationComponent;
import com.mynamesraph.mystcraft.item.LinkingBookItem;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import com.mynamesraph.mystcraft.registry.MystcraftTags;
import com.mynamesraph.pastelpalettes.PastelDyeColor;
import com.mynamesraph.pastelpalettes.item.PastelDyeItem;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\r0\u001bH\u0014J(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0014J8\u0010!\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0011H\u0014J(\u0010'\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)H\u0014J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006/"}, d2={"Lcom/mynamesraph/mystcraft/block/portal/LinkPortalBlock;", "Lnet/minecraft/world/level/block/HalfTransparentBlock;", "Lnet/minecraft/world/level/block/EntityBlock;", "Lnet/minecraft/world/level/block/Portal;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "randomTick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "entityInside", "entity", "Lnet/minecraft/world/entity/Entity;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getPortalDestination", "Lnet/minecraft/world/level/portal/DimensionTransition;", "Companion", "mystcraft_ageless"})
public final class LinkPortalBlock
extends HalfTransparentBlock
implements EntityBlock,
Portal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanProperty PERSISTENT;
    private static final EnumProperty<DyeColor> COLOR;
    private static final BooleanProperty IS_PASTEL_COLOR;
    @NotNull
    private static final Lazy<EnumProperty<PastelDyeColor>> PASTEL_COLOR$delegate;

    public LinkPortalBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            if (ModList.get().isLoaded("past_el_palettes")) {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)COLOR, (Comparable)((DyeItem)item).getDyeColor())).setValue((Property)IS_PASTEL_COLOR, (Comparable)Boolean.valueOf(false)), 3);
                stack.consume(1, (LivingEntity)player);
                return ItemInteractionResult.SUCCESS;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)((DyeItem)item).getDyeColor()), 3);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.SUCCESS;
        }
        if (ModList.get().isLoaded("past_el_palettes") && item instanceof PastelDyeItem) {
            EnumProperty<PastelDyeColor> enumProperty = Companion.getPASTEL_COLOR();
            Intrinsics.checkNotNull(enumProperty);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)enumProperty, (Comparable)((PastelDyeItem)item).getDyeColor())).setValue((Property)IS_PASTEL_COLOR, (Comparable)Boolean.valueOf(true)), 3);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{PERSISTENT};
        StateDefinition.Builder builder2 = builder.add(propertyArray);
        propertyArray = new Property[]{COLOR};
        builder2.add(propertyArray);
        if (ModList.get().isLoaded("past_el_palettes")) {
            propertyArray = new Property[]{IS_PASTEL_COLOR};
            StateDefinition.Builder builder3 = builder.add(propertyArray);
            propertyArray = new Property[1];
            Intrinsics.checkNotNull(Companion.getPASTEL_COLOR());
            builder3.add(propertyArray);
        }
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Block receptacle;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof LinkPortalBlockEntity && level.hasChunkAt(((LinkPortalBlockEntity)be).getReceptaclePosition()) && !((receptacle = level.getBlockState(((LinkPortalBlockEntity)be).getReceptaclePosition()).getBlock()) instanceof BookReceptacleBlock)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (!level.isClientSide()) {
            BlockEntity be;
            if (neighborState.getBlock() instanceof LinkPortalBlock) {
                level.setBlock(pos, neighborState, 11);
            }
            if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && (be = level.getBlockEntity(pos)) instanceof LinkPortalBlockEntity && level.hasChunkAt(((LinkPortalBlockEntity)be).getReceptaclePosition())) {
                BlockEntity receptacle = level.getBlockEntity(((LinkPortalBlockEntity)be).getReceptaclePosition());
                if (receptacle instanceof BookReceptacleBlockEntity) {
                    if (!((BookReceptacleBlockEntity)receptacle).getHasBook()) {
                        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                    }
                } else {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.canUsePortal(true) && !level.isClientSide) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new LinkPortalBlockEntity(pos, state, null, 4, null);
    }

    @Nullable
    public DimensionTransition getPortalDestination(@NotNull ServerLevel level, @NotNull Entity entity, @NotNull BlockPos pos) {
        Item bookItem;
        ItemStack book;
        BlockEntity receptacleBE;
        BlockEntity portalBE;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!level.isClientSide && (portalBE = level.getBlockEntity(pos)) instanceof LinkPortalBlockEntity && (receptacleBE = level.getBlockEntity(((LinkPortalBlockEntity)portalBE).getReceptaclePosition())) instanceof BookReceptacleBlockEntity && ((BookReceptacleBlockEntity)receptacleBE).getHasBook() && (book = ((BookReceptacleBlockEntity)receptacleBE).getBook()).is(MystcraftTags.INSTANCE.getLINKING_BOOK_TAG()) && (bookItem = book.getItem()) instanceof LinkingBookItem) {
            LocationComponent location = (LocationComponent)book.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION().get());
            RotationComponent rotation = (RotationComponent)book.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getROTATION().get());
            if (location != null && rotation != null) {
                return ((LinkingBookItem)bookItem).getDestination((Level)level, entity, location, rotation);
            }
        }
        return null;
    }

    private static final EnumProperty PASTEL_COLOR_delegate$lambda$0() {
        return ModList.get().isLoaded("past_el_palettes") ? EnumProperty.create((String)"pastel_color", PastelDyeColor.class) : null;
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.PERSISTENT;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"PERSISTENT");
        PERSISTENT = booleanProperty;
        COLOR = EnumProperty.create((String)"portal_color", DyeColor.class);
        IS_PASTEL_COLOR = BooleanProperty.create((String)"is_pastel_color");
        PASTEL_COLOR$delegate = LazyKt.lazy(LinkPortalBlock::PASTEL_COLOR_delegate$lambda$0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R7\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\t\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0010\u0010\u0007R#\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/mynamesraph/mystcraft/block/portal/LinkPortalBlock$Companion;", "", "<init>", "()V", "PERSISTENT", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getPERSISTENT", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "COLOR", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/item/DyeColor;", "kotlin.jvm.PlatformType", "getCOLOR", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "IS_PASTEL_COLOR", "getIS_PASTEL_COLOR", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "PASTEL_COLOR", "Lcom/mynamesraph/pastelpalettes/PastelDyeColor;", "getPASTEL_COLOR", "PASTEL_COLOR$delegate", "Lkotlin/Lazy;", "mystcraft_ageless"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getPERSISTENT() {
            return PERSISTENT;
        }

        public final EnumProperty<DyeColor> getCOLOR() {
            return COLOR;
        }

        public final BooleanProperty getIS_PASTEL_COLOR() {
            return IS_PASTEL_COLOR;
        }

        @Nullable
        public final EnumProperty<PastelDyeColor> getPASTEL_COLOR() {
            Lazy lazy = PASTEL_COLOR$delegate;
            return (EnumProperty)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

