/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.block.portal;

import com.mynamesraph.mystcraft.block.portal.LinkPortalBlock;
import com.mynamesraph.mystcraft.block.portal.LinkPortalBlockEntity;
import com.mynamesraph.mystcraft.block.portal.MystcraftPortalSolverKt;
import com.mynamesraph.mystcraft.container.SingleStackHandler;
import com.mynamesraph.mystcraft.registry.MystcraftBlockEntities;
import com.mynamesraph.mystcraft.registry.MystcraftBlocks;
import com.mynamesraph.pastelpalettes.PastelDyeColor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0013H\u0016J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\u0006\u0010'\u001a\u00020\u0013J\b\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020\u001bH\u0002J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lcom/mynamesraph/mystcraft/block/portal/BookReceptacleBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/Container;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "bookHandler", "Lcom/mynamesraph/mystcraft/container/SingleStackHandler;", "validPortalBlocks", "", "Lnet/minecraft/world/level/block/Block;", "getValidPortalBlocks", "()Ljava/util/Set;", "validPortalBlocks$delegate", "Lkotlin/Lazy;", "book", "Lnet/minecraft/world/item/ItemStack;", "getBook", "()Lnet/minecraft/world/item/ItemStack;", "hasBook", "", "getHasBook", "()Z", "clearContent", "", "getContainerSize", "", "isEmpty", "getItem", "slot", "removeItem", "amount", "removeItemNoUpdate", "setItem", "stack", "insertBook", "removeBook", "tryGeneratePortal", "breakPortal", "loadAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "stillValid", "player", "Lnet/minecraft/world/entity/player/Player;", "mystcraft_ageless"})
public final class BookReceptacleBlockEntity
extends BlockEntity
implements Container {
    @NotNull
    private final SingleStackHandler bookHandler;
    @NotNull
    private final Lazy validPortalBlocks$delegate;

    public BookReceptacleBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)MystcraftBlockEntities.INSTANCE.getBOOK_RECEPTACLE_BLOCK_ENTITY().get(), pos, blockState);
        this.bookHandler = new SingleStackHandler();
        this.validPortalBlocks$delegate = LazyKt.lazy(BookReceptacleBlockEntity::validPortalBlocks_delegate$lambda$0);
    }

    @NotNull
    public final Set<Block> getValidPortalBlocks() {
        Lazy lazy = this.validPortalBlocks$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final ItemStack getBook() {
        return this.bookHandler.getItem();
    }

    public final boolean getHasBook() {
        return !this.getBook().isEmpty();
    }

    public void clearContent() {
        this.bookHandler.getItem().copyAndClear();
        this.setChanged();
        this.breakPortal();
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.bookHandler.getItem().isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.getBook();
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = this.bookHandler.extractItem(slot, amount, false);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        this.breakPortal();
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return this.bookHandler.extractItem(64, false);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.bookHandler.setStackInSlot(slot, stack);
        this.setChanged();
        this.tryGeneratePortal();
    }

    @NotNull
    public final ItemStack insertBook(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack leftover = this.bookHandler.insertItem(stack, false);
        this.setChanged();
        this.tryGeneratePortal();
        return leftover;
    }

    @NotNull
    public final ItemStack removeBook() {
        ItemStack book = this.bookHandler.extractItem(1, false);
        this.setChanged();
        this.breakPortal();
        return book;
    }

    private final void tryGeneratePortal() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (!level2.isClientSide) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Object cornersR = MystcraftPortalSolverKt.solveFrameCorners(blockPos, this.getValidPortalBlocks(), level2, 128);
            if (Result.isSuccess-impl((Object)cornersR)) {
                BlockState blockState;
                Object object = cornersR;
                ResultKt.throwOnFailure((Object)object);
                List corners = (List)object;
                if (ModList.get().isLoaded("past_el_palettes")) {
                    boolean isPastel = Random.Default.nextBoolean();
                    if (isPastel) {
                        BlockState blockState2 = (BlockState)((BlockState)((Block)MystcraftBlocks.INSTANCE.getLINK_PORTAL().get()).defaultBlockState().setValue((Property)LinkPortalBlock.Companion.getPERSISTENT(), (Comparable)Boolean.valueOf(false))).setValue((Property)LinkPortalBlock.Companion.getIS_PASTEL_COLOR(), (Comparable)Boolean.valueOf(true));
                        EnumProperty<PastelDyeColor> enumProperty = LinkPortalBlock.Companion.getPASTEL_COLOR();
                        Intrinsics.checkNotNull(enumProperty);
                        blockState = (BlockState)blockState2.setValue((Property)enumProperty, (Comparable)CollectionsKt.random((Collection)((Collection)PastelDyeColor.getEntries()), (Random)((Random)Random.Default)));
                    } else {
                        blockState = (BlockState)((BlockState)((BlockState)((Block)MystcraftBlocks.INSTANCE.getLINK_PORTAL().get()).defaultBlockState().setValue((Property)LinkPortalBlock.Companion.getPERSISTENT(), (Comparable)Boolean.valueOf(false))).setValue((Property)LinkPortalBlock.Companion.getIS_PASTEL_COLOR(), (Comparable)Boolean.valueOf(false))).setValue((Property)LinkPortalBlock.Companion.getCOLOR(), (Comparable)CollectionsKt.random((Collection)((Collection)EntriesMappings.entries$0), (Random)((Random)Random.Default)));
                    }
                } else {
                    blockState = (BlockState)((BlockState)((Block)MystcraftBlocks.INSTANCE.getLINK_PORTAL().get()).defaultBlockState().setValue((Property)LinkPortalBlock.Companion.getPERSISTENT(), (Comparable)Boolean.valueOf(false))).setValue((Property)LinkPortalBlock.Companion.getCOLOR(), (Comparable)CollectionsKt.random((Collection)((Collection)EntriesMappings.entries$0), (Random)((Random)Random.Default)));
                }
                BlockState state = blockState;
                List<BlockPos> points = MystcraftPortalSolverKt.findAllPointsInsidePolygon(corners);
                for (BlockPos point : points) {
                    if (!level2.getBlockState(point).isEmpty()) continue;
                    level2.setBlock(point, state, 3);
                    BlockEntity be = level2.getBlockEntity(point);
                    if (!(be instanceof LinkPortalBlockEntity)) continue;
                    ((LinkPortalBlockEntity)be).setReceptaclePosition(this.getBlockPos());
                    ((LinkPortalBlockEntity)be).setChanged();
                }
            }
        }
    }

    private final void breakPortal() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (!level2.isClientSide) {
            for (Direction direction : EntriesMappings.entries$1) {
                BlockState block = level2.getBlockState(this.getBlockPos().relative(direction));
                if (!block.is((Holder)MystcraftBlocks.INSTANCE.getLINK_PORTAL())) continue;
                level2.destroyBlock(this.getBlockPos().relative(direction), false);
            }
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        if (tag.contains("Book", 10)) {
            this.bookHandler.setStackInSlot(0, ItemStack.parse((HolderLookup.Provider)registries, (Tag)((Tag)tag.getCompound("Book"))).orElse(ItemStack.EMPTY));
        } else {
            this.bookHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        if (this.getHasBook()) {
            tag.put("Book", this.getBook().save(registries));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    private static final Set validPortalBlocks_delegate$lambda$0() {
        Object[] objectArray = new Block[]{MystcraftBlocks.INSTANCE.getBLUE_CRYSTAL_BLOCK().get(), MystcraftBlocks.INSTANCE.getBLUE_BOOK_RECEPTACLE().get(), MystcraftBlocks.INSTANCE.getYELLOW_CRYSTAL_BLOCK().get(), MystcraftBlocks.INSTANCE.getYELLOW_BOOK_RECEPTACLE().get(), MystcraftBlocks.INSTANCE.getGREEN_CRYSTAL_BLOCK().get(), MystcraftBlocks.INSTANCE.getGREEN_BOOK_RECEPTACLE().get(), MystcraftBlocks.INSTANCE.getPINK_CRYSTAL_BLOCK().get(), MystcraftBlocks.INSTANCE.getPINK_BOOK_RECEPTACLE().get(), MystcraftBlocks.INSTANCE.getRED_CRYSTAL_BLOCK().get(), MystcraftBlocks.INSTANCE.getRED_BOOK_RECEPTACLE().get()};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DyeColor> entries$0;
        public static final /* synthetic */ EnumEntries<Direction> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])DyeColor.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

