/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.to_server;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateDimTank(BlockPos pos, Frequency freq, boolean locked, boolean autoEject) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateDimTank> TYPE = new CustomPacketPayload.Type(DimStorage.rl("update_dim_tank"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateDimTank> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateDimTank::pos, Frequency.STREAM_CODEC, UpdateDimTank::freq, (StreamCodec)ByteBufCodecs.BOOL, UpdateDimTank::locked, (StreamCodec)ByteBufCodecs.BOOL, UpdateDimTank::autoEject, UpdateDimTank::new);

    public UpdateDimTank(BlockEntityDimTank tank) {
        this(tank.getBlockPos(), tank.getFrequency(), tank.locked, tank.autoEject);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateDimTank message, IPayloadContext ctx) {
        Player player = ctx.player();
        Level level = player.level();
        level.getBlockEntity(message.pos, (BlockEntityType)Registration.DIMTANK_TILE.get()).ifPresent(tank -> {
            tank.setFrequency(message.freq);
            tank.locked = message.locked;
            tank.autoEject = message.autoEject;
            tank.setChanged();
            level.sendBlockUpdated(message.pos, tank.getBlockState(), tank.getBlockState(), 3);
            player.openMenu((MenuProvider)tank, buf -> buf.writeBlockPos(message.pos).writeBoolean(true));
        });
    }
}

