/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blockentities;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.menu.DimTankMenu;
import edivad.dimstorage.network.TankState;
import edivad.dimstorage.network.to_client.SyncLiquidTank;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimTankStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BlockEntityDimTank
extends BlockEntityFrequencyOwner {
    public DimTankState liquidState = new DimTankState(this.getFrequency());
    public boolean autoEject = false;

    public BlockEntityDimTank(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BlockEntityFrequencyOwner>)((BlockEntityType)Registration.DIMTANK_TILE.get()), pos, state);
    }

    @Override
    public void onServerTick(Level level, BlockPos pos, BlockState state) {
        if (this.autoEject) {
            this.ejectLiquid();
        }
        this.liquidState.update(level);
    }

    @Override
    public void onClientTick(Level level, BlockPos pos, BlockState state) {
        this.liquidState.update(level);
    }

    private void ejectLiquid() {
        for (Direction side : Direction.values()) {
            int qty;
            FluidStack liquid;
            IFluidHandler fluidHandler;
            BlockPos pos = this.worldPosition.relative(side);
            if (this.checkSameFrequency(this.level.getBlockEntity(pos)) || (fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)side.getOpposite())) == null || (liquid = this.getStorage().drain(100, IFluidHandler.FluidAction.SIMULATE)).getAmount() <= 0 || (qty = fluidHandler.fill(liquid, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
            this.getStorage().drain(qty, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean checkSameFrequency(BlockEntity blockentity) {
        if (blockentity instanceof BlockEntityDimTank) {
            BlockEntityDimTank otherTank = (BlockEntityDimTank)blockentity;
            return this.getFrequency().equals(otherTank.getFrequency());
        }
        return false;
    }

    @Override
    public void setFrequency(Frequency frequency) {
        super.setFrequency(frequency);
        if (!this.level.isClientSide) {
            this.liquidState.setFrequency(frequency);
        }
    }

    @Override
    public DimTankStorage getStorage() {
        return (DimTankStorage)DimStorageManager.instance(this.level).getStorage((HolderLookup.Provider)this.level.registryAccess(), this.getFrequency(), "fluid");
    }

    public int getComparatorInput() {
        int amount = this.getStorage().getFluidInTank(0).getAmount();
        return amount / 1000;
    }

    public void swapAutoEject() {
        this.autoEject = !this.autoEject;
        this.setChanged();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("autoEject", this.autoEject);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.liquidState.setFrequency(this.getFrequency());
        this.autoEject = tag.getBoolean("autoEject");
    }

    @Override
    public ItemInteractionResult useItemOn(ServerPlayer player, Level level, BlockPos pos, InteractionHand hand) {
        if (!this.canAccess((Player)player)) {
            player.displayClientMessage((Component)Component.literal((String)"Access Denied!").withStyle(ChatFormatting.RED), false);
            return super.useItemOn(player, level, pos, hand);
        }
        boolean result = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.getStorage());
        if (!result) {
            return super.useItemOn(player, level, pos, hand);
        }
        level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public IFluidHandler getFluidHandler(Direction direction) {
        return this.locked ? null : this.getStorage();
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag root = new CompoundTag();
        root.put("frequency", (Tag)this.getFrequency().serializeNBT());
        root.putBoolean("locked", this.locked);
        root.putBoolean("autoEject", this.autoEject);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        CompoundTag tag = pkt.getTag();
        this.setFrequency(Frequency.deserializeNBT(tag.getCompound("frequency")));
        this.locked = tag.getBoolean("locked");
        this.autoEject = tag.getBoolean("autoEject");
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putBoolean("autoEject", this.autoEject);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.setFrequency(Frequency.deserializeNBT(tag.getCompound("frequency")));
        this.locked = tag.getBoolean("locked");
        this.autoEject = tag.getBoolean("autoEject");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new DimTankMenu(id, inventory, this, false);
    }

    public class DimTankState
    extends TankState {
        public DimTankState(Frequency frequency) {
            super(frequency);
        }

        @Override
        public void sendSyncPacket() {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncLiquidTank(BlockEntityDimTank.this.getBlockPos(), this.serverLiquid), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public void onLiquidChanged() {
            BlockEntityDimTank.this.level.sendBlockUpdated(BlockEntityDimTank.this.getBlockPos(), BlockEntityDimTank.this.getBlockState(), BlockEntityDimTank.this.getBlockState(), 3);
            BlockEntityDimTank.this.level.getChunkSource().getLightEngine().checkBlock(BlockEntityDimTank.this.getBlockPos());
        }
    }
}

