/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.storage;

import com.buuz135.transfer_labels.client.TLAssetProvider;
import com.buuz135.transfer_labels.filter.ILabelFilter;
import com.buuz135.transfer_labels.gui.SmallTextScreenAddon;
import com.buuz135.transfer_labels.item.TransferLabelItem;
import com.buuz135.transfer_labels.storage.LabelBlock;
import com.buuz135.transfer_labels.storage.LabelLocatorInstance;
import com.buuz135.transfer_labels.storage.LabelStorage;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelInstance
implements IScreenAddonProvider,
MenuProvider,
IButtonHandler,
IContainerAddonProvider,
IHasAssetProvider,
INBTSerializable<CompoundTag>,
IComponentHarness {
    private ItemStack label;
    private Level level;
    private BlockPos pos;
    private Direction facing;
    private ILabelFilter filter;
    private final LabelBlock parent;
    private InventoryComponent<LabelInstance> amountFilter;
    private InventoryComponent<LabelInstance> speedFilter;

    public LabelInstance(ItemStack label, Level world, BlockPos pos, Direction direction, LabelBlock parent) {
        this.label = label;
        this.level = world;
        this.pos = pos;
        this.facing = direction;
        this.parent = parent;
        Item item = label.getItem();
        if (item instanceof TransferLabelItem) {
            TransferLabelItem transferLabelItem = (TransferLabelItem)item;
            this.filter = transferLabelItem.createFilter();
        }
        this.amountFilter = new InventoryComponent("amountFilter", 145, 30, 1).setSlotLimit(63).setInputFilter((itemStack, integer) -> ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)label)).setSlotToItemStackRender(0, label).setSlotToColorRender(0, DyeColor.PURPLE);
        this.speedFilter = new InventoryComponent("speedFilter", 145, 66, 1).setSlotLimit(38).setInputFilter((itemStack, integer) -> ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)label)).setSlotToItemStackRender(0, label).setSlotToColorRender(0, DyeColor.LIME);
        this.amountFilter.setComponentHarness((IComponentHarness)this);
        this.speedFilter.setComponentHarness((IComponentHarness)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> arrayList = new ArrayList<IFactory<? extends IScreenAddon>>();
        if (this.filter != null) {
            arrayList.addAll(this.filter.getScreenAddons());
        }
        arrayList.addAll(this.amountFilter.getScreenAddons());
        arrayList.addAll(this.speedFilter.getScreenAddons());
        arrayList.add(() -> new SmallTextScreenAddon(153, 30, "tooltip.transfer_labels.slot.amount"));
        arrayList.add(() -> new SmallTextScreenAddon(153, 66, "tooltip.transfer_labels.slot.speed"));
        return arrayList;
    }

    public IAssetProvider getAssetProvider() {
        return TLAssetProvider.DEFAULT_PROVIDER;
    }

    @NotNull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> arrayList = new ArrayList<IFactory<? extends IContainerAddon>>();
        arrayList.addAll(this.amountFilter.getContainerAddons());
        arrayList.addAll(this.speedFilter.getContainerAddons());
        return arrayList;
    }

    public void handleButtonMessage(int i, Player player, CompoundTag compoundTag) {
        if (i == -2) {
            int slot = compoundTag.getInt("Slot");
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)player.level().registryAccess(), (CompoundTag)compoundTag.getCompound("Filter"));
            this.filter.setFilter(slot, stack);
        }
        if (i == -7) {
            this.filter.handleButtonMessage(i, player, compoundTag);
        }
        if (i == 54571) {
            this.filter.toggleFilterMode();
        }
        this.parent.updateToNearby(player);
    }

    public Component getDisplayName() {
        return Component.literal((String)("Label " + this.facing.getName()));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new BasicAddonContainer((Object)this, (LocatorInstance)new LabelLocatorInstance(this.pos, this.facing), ContainerLevelAccess.create((Level)this.level, (BlockPos)this.pos), inventoryPlayer, menu);
    }

    public ItemStack getLabel() {
        return this.label;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        if (this.filter != null) {
            compoundTag.put("Filter", this.filter.serializeNBT(provider));
        }
        compoundTag.put("AmountFilter", (Tag)this.amountFilter.serializeNBT(provider));
        compoundTag.put("SpeedFilter", (Tag)this.speedFilter.serializeNBT(provider));
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        if (this.filter != null) {
            this.filter.deserializeNBT(provider, (Tag)compoundTag.getCompound("Filter"));
        }
        this.amountFilter.deserializeNBT(provider, compoundTag.getCompound("AmountFilter"));
        this.speedFilter.deserializeNBT(provider, compoundTag.getCompound("SpeedFilter"));
    }

    public void work(Level level) {
        if (this.filter != null && level.getGameTime() % (long)(20 - this.getSpeed()) == 0L) {
            this.filter.work(level, this.pos, this.facing, 1 + this.getAmount());
        }
    }

    public int getSpeed() {
        return this.speedFilter.getStackInSlot(0).getCount() / 2;
    }

    public int getAmount() {
        return this.amountFilter.getStackInSlot(0).getCount();
    }

    public Level getComponentWorld() {
        return this.level;
    }

    public void markComponentForUpdate(boolean b) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LabelStorage.getStorageFor(serverLevel).markDirty();
        }
    }

    public void markComponentDirty() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LabelStorage.getStorageFor(serverLevel).markDirty();
        }
    }

    public InventoryComponent<LabelInstance> getAmountFilter() {
        return this.amountFilter;
    }

    public InventoryComponent<LabelInstance> getSpeedFilter() {
        return this.speedFilter;
    }
}

