/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.filter;

import com.buuz135.transfer_labels.client.TLAssetTypes;
import com.buuz135.transfer_labels.filter.FilterType;
import com.buuz135.transfer_labels.filter.ILabelFilter;
import com.buuz135.transfer_labels.filter.extras.FluidTagFilterExtra;
import com.buuz135.transfer_labels.filter.extras.NumberFilterExtra;
import com.buuz135.transfer_labels.gui.ScrollableScreenAddon;
import com.buuz135.transfer_labels.gui.ScrollableSelectionHelper;
import com.buuz135.transfer_labels.gui.WhitelistStateButtonAddon;
import com.buuz135.transfer_labels.gui.filter.FluidFilterScreenAddon;
import com.buuz135.transfer_labels.item.TransferLabelItem;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidFilter
implements ILabelFilter<FluidStack> {
    private final FilterSlot<FluidStack>[] filter;
    private ILabelFilter.Type type;
    private int pointer;
    private final String name;
    private final HashMap<String, INBTSerializable<CompoundTag>> savedFilters;
    private FilterType filterType;
    private ButtonComponent toggleFilterModeButton;
    private TransferLabelItem.Mode mode;

    public FluidFilter(String name, int filterSize, TransferLabelItem.Mode mode) {
        this.name = name;
        this.filter = new FilterSlot[filterSize];
        this.mode = mode;
        this.type = ILabelFilter.Type.BLACKLIST;
        this.pointer = 0;
        this.filterType = FilterType.NORMAL;
        this.savedFilters = new HashMap();
        this.savedFilters.put(FilterType.REGULATING.getName(), new NumberFilterExtra(filterSize));
        this.savedFilters.put(FilterType.EXACT_COUNT.getName(), new NumberFilterExtra(filterSize));
        this.savedFilters.put(FilterType.TAG.getName(), new FluidTagFilterExtra(filterSize));
        this.toggleFilterModeButton = new ButtonComponent(13, 64, 18, 18);
        this.toggleFilterModeButton.setId(54571);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean acceptsAsFilter(ItemStack filter) {
        return true;
    }

    @Override
    public void setFilter(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        IFluidHandlerItem capability = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (capability != null) {
            fluidStack = capability.getFluidInTank(0);
        }
        this.filter[slot].setFilter((Object)fluidStack.copy());
        NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.EXACT_COUNT.getName());
        numberFilterExtra.getExtra().set(slot, fluidStack.getAmount());
        numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.REGULATING.getName());
        numberFilterExtra.getExtra().set(slot, fluidStack.getAmount());
        FluidTagFilterExtra extra = (FluidTagFilterExtra)this.savedFilters.get(FilterType.TAG.getName());
        extra.initTag(slot, fluidStack);
    }

    @Override
    public void setFilter(int slot, FilterSlot<FluidStack> filterSlot) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        this.filter[slot] = filterSlot;
    }

    @Override
    public FilterSlot<FluidStack>[] getFilterSlots() {
        return this.filter;
    }

    @Override
    public ILabelFilter.Type getType() {
        return this.type;
    }

    @Override
    public void toggleFilterMode() {
        this.type = this.type.equals((Object)ILabelFilter.Type.WHITELIST) ? ILabelFilter.Type.BLACKLIST : ILabelFilter.Type.WHITELIST;
    }

    @Override
    public void handleButtonMessage(int i, Player player, CompoundTag compoundTag) {
        if (compoundTag.contains("Scrollable_Name") && compoundTag.getString("Scrollable_Name").equals("filter_selector")) {
            double scroll = compoundTag.getDouble("Scroll");
            if (scroll > 0.0) {
                this.filterType = FilterType.getPrevious(this.filterType.getName());
            } else if (scroll < 0.0) {
                this.filterType = FilterType.getNext(this.filterType.getName());
            }
        }
        if (compoundTag.contains("FilterAmount")) {
            int slot = compoundTag.getInt("FilterAmount");
            int amount = compoundTag.getInt("Scroll");
            if (this.filterType == FilterType.EXACT_COUNT || this.filterType == FilterType.REGULATING) {
                NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(this.filterType.getName());
                numberFilterExtra.add(slot, amount);
            }
        }
        if (compoundTag.contains("FilterTag")) {
            int slot = compoundTag.getInt("FilterTag");
            int scroll = compoundTag.getInt("Scroll");
            if (this.filterType == FilterType.TAG) {
                FluidTagFilterExtra tagFilterExtra = (FluidTagFilterExtra)this.savedFilters.get(this.filterType.getName());
                if (scroll > 0) {
                    tagFilterExtra.previousTag(slot, (FluidStack)this.filter[slot].getFilter());
                } else if (scroll < 0) {
                    tagFilterExtra.nextTag(slot, (FluidStack)this.filter[slot].getFilter());
                }
            }
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putInt("Pointer", this.pointer);
        CompoundTag filter = new CompoundTag();
        for (FilterSlot<FluidStack> fluidStackFilterSlot : this.filter) {
            if (fluidStackFilterSlot == null) continue;
            filter.put("" + fluidStackFilterSlot.getFilterID(), ((FluidStack)fluidStackFilterSlot.getFilter()).saveOptional(provider));
        }
        compoundNBT.put("Filter", (Tag)filter);
        compoundNBT.putString("Type", this.type.name());
        compoundNBT.putString("FilterType", this.filterType.getName());
        CompoundTag savedFiltersNBT = new CompoundTag();
        this.savedFilters.forEach((key, value) -> savedFiltersNBT.put(key, value.serializeNBT(provider)));
        compoundNBT.put("SavedFilters", (Tag)savedFiltersNBT);
        return compoundNBT;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.pointer = nbt.getInt("Pointer");
        CompoundTag filter = nbt.getCompound("Filter");
        for (FilterSlot<FluidStack> filterSlot : this.filter) {
            filterSlot.setFilter((Object)FluidStack.EMPTY);
        }
        for (String key2 : filter.getAllKeys()) {
            this.filter[Integer.parseInt(key2)].setFilter((Object)FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)filter.getCompound(key2)));
        }
        this.type = ILabelFilter.Type.valueOf(nbt.getString("Type"));
        this.filterType = FilterType.getByName(nbt.getString("FilterType"));
        CompoundTag savedFiltersNBT = nbt.getCompound("SavedFilters");
        this.savedFilters.forEach((key, value) -> value.deserializeNBT(provider, (Tag)savedFiltersNBT.getCompound(key)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        list.add(() -> new FluidFilterScreenAddon(this));
        list.add(() -> {
            ArrayList<String> lines = new ArrayList<String>();
            FilterType.FILTERS.forEach(filterType1 -> lines.addAll(filterType1.getTooltip()));
            lines.add(Component.translatable((String)"filter.type.scroll").withStyle(ChatFormatting.DARK_GRAY).getString());
            return new ScrollableScreenAddon(13, 28, new ScrollableSelectionHelper("filter_selector", -7, lines, () -> Component.translatable((String)this.filterType.getDisplayName()).getString(), false), () -> {
                switch (this.filterType.getName()) {
                    case "normal": {
                        return TLAssetTypes.FILTER_NORMAL;
                    }
                    case "regulating": {
                        return TLAssetTypes.FILTER_REGULATING;
                    }
                    case "exact_count": {
                        return TLAssetTypes.FILTER_EXACT_COUNT;
                    }
                    case "mod": {
                        return TLAssetTypes.FILTER_MOD;
                    }
                    case "tag": {
                        return TLAssetTypes.FILTER_TAG;
                    }
                }
                return AssetTypes.BUTTON_LOCKED;
            });
        });
        list.add(() -> new WhitelistStateButtonAddon(this.toggleFilterModeButton, new StateButtonInfo[]{new StateButtonInfo(0, TLAssetTypes.WHITELIST_BUTTON, new String[]{"tooltip.transfer_labels.whitelist"}), new StateButtonInfo(1, TLAssetTypes.BLACKLIST_BUTTON, new String[]{"tooltip.transfer_labels.blacklist"})}){

            public int getState() {
                return FluidFilter.this.type.equals((Object)ILabelFilter.Type.WHITELIST) ? 0 : 1;
            }
        });
        return list;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public HashMap<String, INBTSerializable<CompoundTag>> getSavedFilters() {
        return this.savedFilters;
    }

    public void onContentChanged() {
    }

    @Override
    public void work(Level level, BlockPos pos, Direction direction, int amount) {
        Direction oppositeDirection = direction.getOpposite();
        BlockPos oppositePos = pos.relative(direction);
        IFluidHandler sourceHandler = null;
        IFluidHandler targetHandler = null;
        if (this.mode == TransferLabelItem.Mode.EXTRACT) {
            targetHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, oppositePos, (Object)oppositeDirection);
            sourceHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)direction);
        } else {
            sourceHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, oppositePos, (Object)oppositeDirection);
            targetHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)direction);
        }
        if (sourceHandler == null || targetHandler == null) {
            return;
        }
        this.transferFluids(sourceHandler, targetHandler, amount * 100);
    }

    private void transferFluids(IFluidHandler sourceHandler, IFluidHandler targetHandler, int defaultMaxAmount) {
        for (int sourceIndex = 0; sourceIndex < sourceHandler.getTanks(); ++sourceIndex) {
            int maxAmount = defaultMaxAmount;
            FluidStack sourceStack = sourceHandler.getFluidInTank(sourceIndex);
            if (sourceStack.isEmpty()) continue;
            FluidStack drainStack = sourceStack.copy();
            drainStack.setAmount(maxAmount);
            FluidStack drained = sourceHandler.drain(drainStack, IFluidHandler.FluidAction.SIMULATE);
            if (drained.isEmpty() || drained.getAmount() <= 0 || !this.passesFilter(drained) || (maxAmount = this.calculateMaxTransferAmount(drained, sourceHandler, targetHandler, sourceIndex, defaultMaxAmount)) <= 0) continue;
            drainStack.setAmount(maxAmount);
            drained = sourceHandler.drain(drainStack, IFluidHandler.FluidAction.SIMULATE);
            int filled = targetHandler.fill(drained, IFluidHandler.FluidAction.SIMULATE);
            if (filled <= 0) continue;
            FluidStack actualDrain = sourceHandler.drain(new FluidStack(drained.getFluid(), filled), IFluidHandler.FluidAction.EXECUTE);
            targetHandler.fill(actualDrain, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
    }

    private int calculateMaxTransferAmount(FluidStack sourceStack, IFluidHandler sourceHandler, IFluidHandler targetHandler, int sourceIndex, int defaultMaxAmount) {
        int maxAmount;
        block3: {
            block4: {
                maxAmount = defaultMaxAmount;
                if (this.filterType != FilterType.REGULATING) break block4;
                for (FilterSlot<FluidStack> filterSlot : this.filter) {
                    if (filterSlot == null || ((FluidStack)filterSlot.getFilter()).isEmpty() || !this.areFluidStacksEqual((FluidStack)filterSlot.getFilter(), sourceStack)) continue;
                    int currentAmount = 0;
                    for (int targetIndex = 0; targetIndex < targetHandler.getTanks(); ++targetIndex) {
                        FluidStack targetStack = targetHandler.getFluidInTank(targetIndex);
                        if (targetStack.isEmpty() || !this.areFluidStacksEqual(targetStack, (FluidStack)filterSlot.getFilter())) continue;
                        currentAmount += targetStack.getAmount();
                    }
                    NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.REGULATING.getName());
                    int desiredAmount = numberFilterExtra.getExtra().get(filterSlot.getFilterID());
                    int neededAmount = Math.max(0, desiredAmount - currentAmount);
                    maxAmount = Math.min(neededAmount, defaultMaxAmount);
                    break block3;
                }
                break block3;
            }
            if (this.filterType != FilterType.EXACT_COUNT) break block3;
            for (FilterSlot<FluidStack> filterSlot : this.filter) {
                if (filterSlot == null || ((FluidStack)filterSlot.getFilter()).isEmpty() || !this.areFluidStacksEqual((FluidStack)filterSlot.getFilter(), sourceStack)) continue;
                NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.EXACT_COUNT.getName());
                int exactAmount = numberFilterExtra.getExtra().get(filterSlot.getFilterID());
                maxAmount = exactAmount > defaultMaxAmount ? 0 : exactAmount;
                break;
            }
        }
        return maxAmount;
    }

    private boolean areFluidStacksEqual(FluidStack stack1, FluidStack stack2) {
        return FluidStack.isSameFluidSameComponents((FluidStack)stack1, (FluidStack)stack2);
    }

    private boolean passesFilter(FluidStack stack) {
        if (this.filter.length == 0) {
            return true;
        }
        boolean matches = false;
        for (FilterSlot<FluidStack> filterSlot : this.filter) {
            FluidTagFilterExtra tagFilterExtra;
            TagKey<Fluid> tagKey;
            if (filterSlot == null || ((FluidStack)filterSlot.getFilter()).isEmpty()) continue;
            boolean fluidMatches = false;
            if (this.filterType == FilterType.NORMAL) {
                fluidMatches = ((FluidStack)filterSlot.getFilter()).isFluidEqual(stack);
            } else if (this.filterType == FilterType.REGULATING) {
                fluidMatches = ((FluidStack)filterSlot.getFilter()).isFluidEqual(stack);
            } else if (this.filterType == FilterType.EXACT_COUNT) {
                fluidMatches = ((FluidStack)filterSlot.getFilter()).isFluidEqual(stack);
            } else if (this.filterType == FilterType.MOD) {
                String stackModId = BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()).getNamespace();
                String filterModId = BuiltInRegistries.FLUID.getKey((Object)((FluidStack)filterSlot.getFilter()).getFluid()).getNamespace();
                fluidMatches = stackModId.equals(filterModId);
            } else if (this.filterType == FilterType.TAG && (tagKey = (tagFilterExtra = (FluidTagFilterExtra)this.savedFilters.get(FilterType.TAG.getName())).getExtra().get(filterSlot.getFilterID())) != null) {
                fluidMatches = stack.getFluid().defaultFluidState().is(tagKey);
            }
            if (!fluidMatches) continue;
            matches = true;
            break;
        }
        return this.type.getFilter().test(matches);
    }
}

