/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.client;

import com.buuz135.transfer_labels.storage.LabelBlock;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayTraceUtils {
    public static HitResult rayTraceSimple(Level world, LivingEntity living, double blockReachDistance, float partialTicks) {
        Vec3 vec3d = living.getEyePosition(partialTicks);
        Vec3 vec3d1 = living.getViewVector(partialTicks);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * blockReachDistance, vec3d1.y * blockReachDistance, vec3d1.z * blockReachDistance);
        return world.clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
    }

    @Nullable
    public static Pair<LabelBlock, Direction> rayTraceVoxelShape(List<LabelBlock> nearbyLabels, Level world, LivingEntity living, float partialTicks, BlockPos pos) {
        VoxelShape defaultShape;
        BlockHitResult result;
        double blockReachDistance = living.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
        Vec3 vec3d = living.getEyePosition(partialTicks);
        Vec3 vec3d1 = living.getViewVector(partialTicks);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * blockReachDistance, vec3d1.y * blockReachDistance, vec3d1.z * blockReachDistance);
        LabelBlock closest = null;
        Direction direction = null;
        double distance = Double.MAX_VALUE;
        if (pos != null && (result = (defaultShape = world.getBlockState(pos).getShape((BlockGetter)world, pos)).clip(vec3d, vec3d2, pos)) != null) {
            distance = vec3d.distanceTo(result.getLocation());
        }
        for (LabelBlock nearbyLabel : nearbyLabels) {
            for (Direction direction2 : Direction.values()) {
                Optional result2;
                AABB voxelShape = nearbyLabel.collectShapes(direction2);
                if (voxelShape == null || !(result2 = voxelShape.clip(vec3d, vec3d2)).isPresent() || !(vec3d.distanceTo((Vec3)result2.get()) < distance)) continue;
                closest = nearbyLabel;
                direction = direction2;
                distance = vec3d.distanceTo((Vec3)result2.get());
            }
        }
        if (closest != null) {
            return Pair.of(closest, direction);
        }
        return null;
    }
}

