/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ice;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellSummonEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedAptrgangr;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedDraugur;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedEliteDraugur;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedRoyalDraugur;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.ice.AbstractMaledictusSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@AutoSpellConfig
public class ConjureThrallsSpell
extends AbstractMaledictusSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"conjure_thralls");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(10).setCooldownSeconds(120.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.thrall_count", (Object[])new Object[]{spellLevel}));
    }

    public ConjureThrallsSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 80;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTimer = 12000;
        for (int i = 0; i < spellLevel; ++i) {
            Vec3 vec = entity.getEyePosition();
            double randomNearbyX = vec.x + entity.getRandom().nextGaussian() * 3.0;
            double randomNearbyZ = vec.z + entity.getRandom().nextGaussian() * 3.0;
            this.spawnThrallsNearby(randomNearbyX, vec.y, randomNearbyZ, entity, level, summonTimer, spellLevel);
        }
        MobEffectInstance effect = new MobEffectInstance(CSPotionEffectRegistry.DRAUGUR_TIMER);
        entity.addEffect(effect);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnThrallsNearby(double x, double y, double z, LivingEntity caster, Level level, int summonTimer, int spellLevel) {
        MobEffectInstance effect = new MobEffectInstance(CSPotionEffectRegistry.DRAUGUR_TIMER, summonTimer, 0, false, false, false);
        boolean isRoyal = Utils.random.nextDouble() < 0.4;
        boolean isElite = Utils.random.nextDouble() < 0.5;
        boolean isAptrgangr = Utils.random.nextDouble() < 0.2;
        boolean isBase = Utils.random.nextDouble() < 0.6;
        boolean isFullArmy = Utils.random.nextDouble() < 0.75;
        SummonedDraugur draugur = new SummonedDraugur(level, caster);
        SummonedRoyalDraugur royalDraugur = new SummonedRoyalDraugur(level, caster);
        SummonedEliteDraugur eliteDraugur = new SummonedEliteDraugur(level, caster);
        SummonedAptrgangr aptrgangr = new SummonedAptrgangr(level, caster);
        IMagicSummon isBaseDraugur = isRoyal ? draugur : royalDraugur;
        IMagicSummon isEliteDraugur = isElite ? eliteDraugur : royalDraugur;
        SummonedAptrgangr isAptrgangrDraugur = isAptrgangr ? aptrgangr : isEliteDraugur;
        IMagicSummon baseArmy = isBase ? isBaseDraugur : isEliteDraugur;
        IMagicSummon draugurArmry = isFullArmy ? baseArmy : isAptrgangrDraugur;
        SpellSummonEvent event = (SpellSummonEvent)NeoForge.EVENT_BUS.post((Event)new SpellSummonEvent(caster, (LivingEntity)draugurArmry, this.spellId, spellLevel));
        draugurArmry.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(draugurArmry.getOnPos()), MobSpawnType.MOB_SUMMONED, null);
        draugurArmry.moveTo(x, y, z);
        draugurArmry.addEffect(effect);
        level.addFreshEntity((Entity)event.getCreature());
    }
}

