/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.holy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellSummonEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedKoboldiator;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@AutoSpellConfig
public class ConjureKoboldiatorSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"conjure_koboldiator");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(1).setCooldownSeconds(200.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.koboldiator_count", (Object[])new Object[]{spellLevel}));
    }

    public ConjureKoboldiatorSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 80;
        this.baseManaCost = 250;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTimer = 12000;
        for (int i = 0; i < spellLevel; ++i) {
            Vec3 vec = entity.getEyePosition();
            double randomNearbyX = vec.x + entity.getRandom().nextGaussian() * 3.0;
            double randomNearbyZ = vec.z + entity.getRandom().nextGaussian() * 3.0;
            this.spawnKoboldiator(randomNearbyX, vec.y, randomNearbyZ, entity, level, summonTimer, spellLevel);
        }
        MobEffectInstance effect = new MobEffectInstance(CSPotionEffectRegistry.KOBOLDIATOR_TIMER, summonTimer, 0, false, false, false);
        entity.addEffect(effect);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnKoboldiator(double x, double y, double z, LivingEntity caster, Level level, int summonTimer, int spellLevel) {
        MobEffectInstance effect = new MobEffectInstance(CSPotionEffectRegistry.KOBOLDIATOR_TIMER, summonTimer, 0, false, false, false);
        SummonedKoboldiator kobolediator = new SummonedKoboldiator(level, caster);
        SpellSummonEvent event = (SpellSummonEvent)NeoForge.EVENT_BUS.post((Event)new SpellSummonEvent(caster, (LivingEntity)kobolediator, this.spellId, spellLevel));
        kobolediator.moveTo(x, y, z);
        kobolediator.setSleep(false);
        kobolediator.addEffect(effect);
        level.addFreshEntity((Entity)event.getCreature());
    }
}

