/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ender;

import com.github.L_Ender.cataclysm.init.ModItems;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class GravitationPullSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"gravitation_pull");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(5).setCooldownSeconds(30.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.gravitation"), Component.translatable((String)"ui.cataclysm_spellbooks.range", (Object[])new Object[]{spellLevel}), Component.translatable((String)"ui.cataclysm_spellbooks.difference", (Object[])new Object[]{Float.valueOf(this.getDifference(spellLevel, caster))}));
    }

    public GravitationPullSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 5;
        this.castTime = 100;
        this.baseManaCost = 10;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.PORTAL_AMBIENT);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Item gauntlet = (Item)ModItems.GAUNTLET_OF_GUARD.get();
        double radius = entity.getOffhandItem().is(gauntlet) || entity.getMainHandItem().is(gauntlet) ? (double)(spellLevel * 15) : (double)(spellLevel * 10);
        List entitiesNearby = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(radius));
        entitiesNearby.forEach(target -> {
            block8: {
                block7: {
                    if (target == entity) break block7;
                    if (!(target instanceof Player)) break block8;
                    Player player = (Player)target;
                    if (!player.getAbilities().invulnerable) break block8;
                }
                return;
            }
            Vec3 difference = entity.position().subtract(target.position().add(0.0, 0.0, 0.0));
            difference = difference.normalize().scale((double)this.getDifference(spellLevel, entity));
            if (entity.isCrouching()) {
                target.setDeltaMovement(difference.multiply((double)(-this.getDifference(spellLevel, entity)), (double)(-this.getDifference(spellLevel, entity)), (double)(-this.getDifference(spellLevel, entity))));
            } else {
                float distance = target.distanceTo((Entity)entity);
                if (distance <= 1.0f) {
                    return;
                }
                double overshot = difference.length() / (double)distance;
                if (overshot > 1.0) {
                    difference = new Vec3(difference.x() / overshot, difference.y() / overshot, difference.z() / overshot);
                }
                difference = difference.multiply((double)this.getDifference(spellLevel, entity), (double)this.getDifference(spellLevel, entity), (double)this.getDifference(spellLevel, entity));
                target.setDeltaMovement(difference);
            }
        });
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDifference(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) / 2.0f;
    }
}

