/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal;

import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal.AbstractAbyssalSpell;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class AbyssalSlashSpell
extends AbstractAbyssalSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"abyssal_slash");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(CSSchoolRegistry.ABYSSAL_RESOURCE).setMaxLevel(8).setCooldownSeconds(40.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}));
    }

    public AbyssalSlashSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 3;
        this.castTime = 15;
        this.baseManaCost = 35;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FLAMING_STRIKE_UPSWING.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.ABYSS_BLAST_ONLY_SHOOT.get());
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public void onClientPreCast(Level level, int spellLevel, LivingEntity entity, InteractionHand hand, @Nullable MagicData playerMagicData) {
        super.onClientPreCast(level, spellLevel, entity, hand, playerMagicData);
        this.spawnParticles(entity);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = 4.1f;
        float distance = 2.0f;
        Vec3 slashLocation = entity.position().add(entity.getForward().multiply((double)distance, (double)0.3f, (double)distance));
        this.spawnParticles(entity);
        List entities = level.getEntities((Entity)entity, AABB.ofSize((Vec3)slashLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity targetEntity : entities) {
            if (!entity.isPickable() || !(entity.distanceToSqr(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)targetEntity.getBoundingBox().getCenter(), (boolean)true) || !DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)this.getDamageSource((Entity)entity))) continue;
            if (targetEntity instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)targetEntity;
                Boolean hasBurn = livingTarget.hasEffect((Holder)ModEffect.EFFECTABYSSAL_BURN);
                Boolean hasFear = livingTarget.hasEffect((Holder)ModEffect.EFFECTABYSSAL_FEAR);
                Boolean hasCurse = livingTarget.hasEffect((Holder)ModEffect.EFFECTABYSSAL_CURSE);
                if (hasCurse.booleanValue() || hasBurn.booleanValue() || hasFear.booleanValue()) {
                    float bonus = 0.2f;
                    float bonusDamage = this.getDamage(spellLevel, entity) * bonus;
                    float totalDamage = this.getDamage(spellLevel, entity) + bonusDamage;
                    DamageSources.applyDamage((Entity)livingTarget, (float)totalDamage, (DamageSource)this.getDamageSource((Entity)entity));
                }
            }
            EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)targetEntity, (DamageSource)this.getDamageSource((Entity)entity));
        }
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(10, entity.position(), 10.0f));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) + Utils.getWeaponDamage((LivingEntity)caster);
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    private void spawnParticles(LivingEntity entity) {
        ServerLevel level = (ServerLevel)entity.level();
        level.sendParticles((ParticleOptions)((SimpleParticleType)ModParticle.SHOCK_WAVE.get()), entity.getX(), entity.getY() + 1.0, entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }
}

