/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.spells.hellish_blade;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.entity.spells.EarthquakeAoe;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.blazing_aoe.BlazingAoE;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSEntityRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HellishBladeProjectile
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HellishBladeProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoGravity(true);
    }

    public HellishBladeProjectile(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)CSEntityRegistry.HELLISH_BLADE_PROJECTILE.get()), level);
        this.setOwner((Entity)shooter);
    }

    public void trailParticles() {
        Vec3 vec3 = this.position().subtract(this.getDeltaMovement());
        this.level().addParticle((ParticleOptions)ModParticle.TRAP_FLAME.get(), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)((ParticleOptions)ModParticle.TRAP_FLAME.get()), (double)x, (double)y, (double)z, (int)5, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
    }

    public float getSpeed() {
        return 0.8f;
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.of(ModSounds.IGNIS_IMPACT);
    }

    protected void doImpactSound(Holder<SoundEvent> sound) {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), sound, SoundSource.NEUTRAL, 1.5f, 1.0f);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity target = pResult.getEntity();
        DamageSources.applyDamage((Entity)target, (float)this.damage, (DamageSource)SpellRegistries.HELLISH_BLADE.get().getDamageSource((Entity)this, this.getOwner()));
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.addEffect(new MobEffectInstance((Holder)ModEffect.EFFECTBLAZING_BRAND, 100, 0));
            livingTarget.addEffect(new MobEffectInstance((Holder)ModEffect.EFFECTSTUN, 60, 0));
            if (livingTarget instanceof Player) {
                Player playerTarget = (Player)livingTarget;
                playerTarget.disableShield();
            }
            ScreenShake_Entity.ScreenShake((Level)this.level(), (Vec3)livingTarget.position(), (float)20.0f, (float)0.1f, (int)20, (int)40);
        }
        this.discard();
    }

    protected void onHit(HitResult hitresult) {
        super.onHit(hitresult);
        this.createAoEField(hitresult.getLocation());
        EarthquakeAoe aoe = new EarthquakeAoe(this.level());
        aoe.moveTo(this.position());
        aoe.setOwner((Entity)this);
        aoe.setCircular();
        aoe.setRadius(10.0f);
        aoe.setDuration(20);
        aoe.setDamage(1.0f);
        aoe.setSlownessAmplifier(0);
        this.level().addFreshEntity((Entity)aoe);
        this.discard();
    }

    public void createAoEField(Vec3 location) {
        if (!this.level().isClientSide) {
            BlazingAoE aoE = new BlazingAoE(this.level());
            aoE.setOwner(this.getOwner());
            aoE.setDuration(100);
            aoE.setDamage(1.5f);
            aoE.setRadius(4.5f);
            aoE.setCircular();
            aoE.moveTo(location);
            this.level().addFreshEntity((Entity)aoE);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

