/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.processor;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public interface ITemplateFeatureProcessor {
    public static final BlockState AIR = Blocks.AIR.defaultBlockState();
    public static final TagKey<Biome> BADLANDS_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yungsbridges", (String)"collections/badlands"));
    public static final TagKey<Biome> TAIGA_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yungsbridges", (String)"collections/taiga"));
    public static final TagKey<Biome> SAVANNA_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yungsbridges", (String)"collections/savanna"));
    public static final TagKey<Biome> JUNGLE_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yungsbridges", (String)"collections/jungle"));

    public void processTemplate(StructureTemplate var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, BlockPos var5, StructurePlaceSettings var6);

    default public void generatePillarDown(WorldGenLevel level, BlockPos pos, Supplier<BlockState> replacementBlockSupplier, Supplier<BlockState> legBlockSupplier) {
        level.setBlock(pos, replacementBlockSupplier.get(), 2);
        BlockPos.MutableBlockPos mutable = pos.below().mutable();
        BlockState currBlock = level.getBlockState((BlockPos)mutable);
        while (mutable.getY() > 0 && (currBlock.isAir() || currBlock.liquid())) {
            level.setBlock((BlockPos)mutable, legBlockSupplier.get(), 2);
            mutable.move(Direction.DOWN);
            currBlock = level.getBlockState((BlockPos)mutable);
        }
    }

    default public BlockState getStairsBlockWithState(BlockState input, BlockState source) {
        if (input.getBlock() instanceof StairBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)input.setValue((Property)StairBlock.FACING, (Comparable)(source.hasProperty((Property)StairBlock.FACING) ? (Direction)source.getValue((Property)StairBlock.FACING) : Direction.NORTH))).setValue((Property)StairBlock.HALF, (Comparable)(source.hasProperty((Property)StairBlock.HALF) ? (Half)source.getValue((Property)StairBlock.HALF) : Half.BOTTOM))).setValue((Property)StairBlock.SHAPE, (Comparable)(source.hasProperty((Property)StairBlock.SHAPE) ? (StairsShape)source.getValue((Property)StairBlock.SHAPE) : StairsShape.STRAIGHT))).setValue((Property)StairBlock.WATERLOGGED, (Comparable)(source.hasProperty((Property)StairBlock.WATERLOGGED) ? (Boolean)source.getValue((Property)StairBlock.WATERLOGGED) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getSlabBlockWithState(BlockState input, BlockState source) {
        if (input.getBlock() instanceof SlabBlock) {
            return (BlockState)((BlockState)input.setValue((Property)SlabBlock.TYPE, (Comparable)(source.hasProperty((Property)SlabBlock.TYPE) ? (SlabType)source.getValue((Property)SlabBlock.TYPE) : SlabType.BOTTOM))).setValue((Property)SlabBlock.WATERLOGGED, (Comparable)(source.hasProperty((Property)SlabBlock.WATERLOGGED) ? (Boolean)source.getValue((Property)SlabBlock.WATERLOGGED) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getWallBlockWithState(BlockState input, BlockState source) {
        if (input.getBlock() instanceof WallBlock && source.getBlock() instanceof WallBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)input.setValue((Property)WallBlock.NORTH_WALL, (Comparable)(source.hasProperty((Property)WallBlock.NORTH_WALL) ? (WallSide)source.getValue((Property)WallBlock.NORTH_WALL) : WallSide.NONE))).setValue((Property)WallBlock.EAST_WALL, (Comparable)(source.hasProperty((Property)WallBlock.EAST_WALL) ? (WallSide)source.getValue((Property)WallBlock.EAST_WALL) : WallSide.NONE))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)(source.hasProperty((Property)WallBlock.SOUTH_WALL) ? (WallSide)source.getValue((Property)WallBlock.SOUTH_WALL) : WallSide.NONE))).setValue((Property)WallBlock.WEST_WALL, (Comparable)(source.hasProperty((Property)WallBlock.WEST_WALL) ? (WallSide)source.getValue((Property)WallBlock.WEST_WALL) : WallSide.NONE))).setValue((Property)WallBlock.UP, (Comparable)(source.hasProperty((Property)WallBlock.UP) ? (Boolean)source.getValue((Property)WallBlock.UP) : Boolean.valueOf(true)))).setValue((Property)WallBlock.WATERLOGGED, (Comparable)(source.hasProperty((Property)WallBlock.WATERLOGGED) ? (Boolean)source.getValue((Property)WallBlock.WATERLOGGED) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getFenceBlockWithState(BlockState input, BlockState source) {
        if (input.getBlock() instanceof FenceBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)input.setValue((Property)FenceBlock.NORTH, (Comparable)(source.hasProperty((Property)FenceBlock.NORTH) ? (Boolean)source.getValue((Property)FenceBlock.NORTH) : Boolean.valueOf(false)))).setValue((Property)FenceBlock.EAST, (Comparable)(source.hasProperty((Property)FenceBlock.EAST) ? (Boolean)source.getValue((Property)FenceBlock.EAST) : Boolean.valueOf(false)))).setValue((Property)FenceBlock.SOUTH, (Comparable)(source.hasProperty((Property)FenceBlock.SOUTH) ? (Boolean)source.getValue((Property)FenceBlock.SOUTH) : Boolean.valueOf(false)))).setValue((Property)FenceBlock.WEST, (Comparable)(source.hasProperty((Property)FenceBlock.WEST) ? (Boolean)source.getValue((Property)FenceBlock.WEST) : Boolean.valueOf(false)))).setValue((Property)FenceBlock.WATERLOGGED, (Comparable)(source.hasProperty((Property)FenceBlock.WATERLOGGED) ? (Boolean)source.getValue((Property)FenceBlock.WATERLOGGED) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getLogBlockWithState(BlockState input, BlockState source) {
        if (input.getBlock() instanceof RotatedPillarBlock) {
            return (BlockState)input.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)(source.hasProperty((Property)RotatedPillarBlock.AXIS) ? (Direction.Axis)source.getValue((Property)RotatedPillarBlock.AXIS) : Direction.Axis.Y));
        }
        return input;
    }

    default public BlockState getLanternBlockWithState(BlockState input, BlockState source) {
        if (input.getBlock() instanceof LanternBlock) {
            return (BlockState)((BlockState)input.setValue((Property)LanternBlock.HANGING, (Comparable)(source.hasProperty((Property)LanternBlock.HANGING) ? (Boolean)source.getValue((Property)LanternBlock.HANGING) : Boolean.valueOf(true)))).setValue((Property)LanternBlock.WATERLOGGED, (Comparable)(source.hasProperty((Property)LanternBlock.WATERLOGGED) ? (Boolean)source.getValue((Property)LanternBlock.WATERLOGGED) : Boolean.valueOf(true)));
        }
        return input;
    }

    default public BlockState getFenceBiomeVariant(Holder<Biome> biome) {
        if (biome.is(BADLANDS_TAG)) {
            return Blocks.DARK_OAK_FENCE.defaultBlockState();
        }
        if (biome.is(TAIGA_TAG)) {
            return Blocks.SPRUCE_FENCE.defaultBlockState();
        }
        if (biome.is(JUNGLE_TAG)) {
            return Blocks.JUNGLE_FENCE.defaultBlockState();
        }
        if (biome.is(SAVANNA_TAG)) {
            return Blocks.ACACIA_FENCE.defaultBlockState();
        }
        return Blocks.OAK_FENCE.defaultBlockState();
    }

    default public BlockState getLogBiomeVariant(Holder<Biome> biome) {
        if (biome.is(BADLANDS_TAG)) {
            return Blocks.DARK_OAK_LOG.defaultBlockState();
        }
        if (biome.is(TAIGA_TAG)) {
            return Blocks.SPRUCE_LOG.defaultBlockState();
        }
        if (biome.is(JUNGLE_TAG)) {
            return Blocks.JUNGLE_LOG.defaultBlockState();
        }
        if (biome.is(SAVANNA_TAG)) {
            return Blocks.ACACIA_LOG.defaultBlockState();
        }
        return Blocks.OAK_LOG.defaultBlockState();
    }

    default public BlockState getPlanksBiomeVariant(Holder<Biome> biome) {
        if (biome.is(BADLANDS_TAG)) {
            return Blocks.DARK_OAK_PLANKS.defaultBlockState();
        }
        if (biome.is(TAIGA_TAG)) {
            return Blocks.SPRUCE_PLANKS.defaultBlockState();
        }
        if (biome.is(JUNGLE_TAG)) {
            return Blocks.JUNGLE_PLANKS.defaultBlockState();
        }
        if (biome.is(SAVANNA_TAG)) {
            return Blocks.ACACIA_PLANKS.defaultBlockState();
        }
        return Blocks.OAK_PLANKS.defaultBlockState();
    }

    default public BlockState getSlabBiomeVariant(Holder<Biome> biome) {
        if (biome.is(BADLANDS_TAG)) {
            return Blocks.DARK_OAK_SLAB.defaultBlockState();
        }
        if (biome.is(TAIGA_TAG)) {
            return Blocks.SPRUCE_SLAB.defaultBlockState();
        }
        if (biome.is(JUNGLE_TAG)) {
            return Blocks.JUNGLE_SLAB.defaultBlockState();
        }
        if (biome.is(SAVANNA_TAG)) {
            return Blocks.ACACIA_SLAB.defaultBlockState();
        }
        return Blocks.OAK_SLAB.defaultBlockState();
    }

    default public BlockState getStairsBiomeVariant(Holder<Biome> biome) {
        if (biome.is(BADLANDS_TAG)) {
            return Blocks.DARK_OAK_STAIRS.defaultBlockState();
        }
        if (biome.is(TAIGA_TAG)) {
            return Blocks.SPRUCE_STAIRS.defaultBlockState();
        }
        if (biome.is(JUNGLE_TAG)) {
            return Blocks.JUNGLE_STAIRS.defaultBlockState();
        }
        if (biome.is(SAVANNA_TAG)) {
            return Blocks.ACACIA_STAIRS.defaultBlockState();
        }
        return Blocks.OAK_STAIRS.defaultBlockState();
    }
}

