/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.tier.BaseTier;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.DynamicChemicalHandler;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import mekanism.common.content.network.ChemicalNetwork;
import mekanism.common.content.network.transmitter.PressurizedTube;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPressurizedTube
extends TileEntityTransmitter
implements IComputerTile,
ITileRadioactive {
    private final ChemicalHandlerManager chemicalHandlerManager;

    public TileEntityPressurizedTube(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        Predicate<@Nullable Direction> canExtract = this.getExtractPredicate();
        Predicate<@Nullable Direction> canInsert = this.getInsertPredicate();
        this.chemicalHandlerManager = new ChemicalHandlerManager(direction -> {
            PressurizedTube tube = this.getTransmitter();
            if (direction != null && tube.getConnectionTypeRaw(direction) == ConnectionType.NONE || tube.isRedstoneActivated()) {
                return Collections.emptyList();
            }
            return tube.getChemicalTanks(direction);
        }, new DynamicChemicalHandler(this::getChemicalTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.chemicalHandlerManager);
    }

    protected PressurizedTube createTransmitter(Holder<Block> blockProvider) {
        return new PressurizedTube(blockProvider, this);
    }

    public PressurizedTube getTransmitter() {
        return (PressurizedTube)super.getTransmitter();
    }

    @Override
    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull BaseTier tier) {
        return BlockStateHelper.copyStateData(current, switch (tier) {
            case BaseTier.BASIC -> MekanismBlocks.BASIC_PRESSURIZED_TUBE;
            case BaseTier.ADVANCED -> MekanismBlocks.ADVANCED_PRESSURIZED_TUBE;
            case BaseTier.ELITE -> MekanismBlocks.ELITE_PRESSURIZED_TUBE;
            case BaseTier.ULTIMATE -> MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE;
            default -> null;
        });
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getUpdateTag(provider);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ChemicalNetwork network = (ChemicalNetwork)this.getTransmitter().getTransmitterNetwork();
            if (!network.lastChemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                DataResult encoded = Chemical.HOLDER_CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), network.lastChemical);
                if (encoded.isSuccess()) {
                    updateTag.put("chemical", (Tag)encoded.getOrThrow());
                } else {
                    encoded.ifError(error -> Mekanism.logger.warn("Failed to encode last chemical: {}", (Object)error.message()));
                }
            }
            updateTag.putFloat("scale", network.currentScale);
        }
        return updateTag;
    }

    @Override
    public float getRadiationScale() {
        if (IRadiationManager.INSTANCE.isRadiationEnabled()) {
            PressurizedTube tube = this.getTransmitter();
            if (this.isRemote()) {
                if (tube.hasTransmitterNetwork()) {
                    ChemicalNetwork network = (ChemicalNetwork)tube.getTransmitterNetwork();
                    if (!network.lastChemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY) && !network.getChemicalTank().isEmpty() && ((Chemical)network.lastChemical.value()).isRadioactive()) {
                        return network.currentScale;
                    }
                }
            } else {
                IChemicalTank gasTank = tube.getChemicalTank();
                if (!gasTank.isEmpty() && gasTank.getStack().isRadioactive()) {
                    return (float)gasTank.getStored() / (float)gasTank.getCapacity();
                }
            }
        }
        return 0.0f;
    }

    @Override
    public int getRadiationParticleCount() {
        return MathUtils.clampToInt(3.0f * this.getRadiationScale());
    }

    private List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        return this.chemicalHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.CHEMICAL.block(), side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    @Override
    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilityAll(Capabilities.CHEMICAL.block());
        } else {
            this.invalidateCapabilities();
        }
    }

    @Override
    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "PressurizedTube";
    }

    @ComputerMethod
    ChemicalStack getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    long getCapacity() {
        PressurizedTube tube = this.getTransmitter();
        return tube.hasTransmitterNetwork() ? ((ChemicalNetwork)tube.getTransmitterNetwork()).getCapacity() : tube.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - this.getBuffer().getAmount();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

