/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.common.attachments.LockData;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.lib.inventory.HandlerTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.BinTier;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.upgrade.BinUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBin
extends TileEntityMekanism
implements IConfigurable {
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> targetInventory;
    public int addTicks = 0;
    public int removeTicks = 0;
    private int delayTicks;
    private boolean needsSync;
    private BinTier tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getStored"}, docPlaceholder="bin")
    BinInventorySlot binSlot;

    public TileEntityBin(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.tier = Attribute.getTier(this.getBlockHolder(), BinTier.class);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        this.binSlot = BinInventorySlot.create(listener, this.tier);
        builder.addSlot(this.binSlot);
        return builder.build();
    }

    public BinTier getTier() {
        return this.tier;
    }

    public BinInventorySlot getBinSlot() {
        return this.binSlot;
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.addTicks = Math.max(0, this.addTicks - 1);
        this.removeTicks = Math.max(0, this.removeTicks - 1);
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 0) {
            if (this.getActive()) {
                TransitRequest.TransitResponse response;
                IItemHandler capability = (IItemHandler)CapabilityTileEntity.ITEM_HANDLER_PROVIDER.getCapability((Object)this, (Object)Direction.DOWN);
                HandlerTransitRequest request = new HandlerTransitRequest(capability);
                request.addItem(this.binSlot.getBottomStack(), 0);
                if (this.targetInventory == null) {
                    this.targetInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, this.getBlockPos().below(), Direction.UP);
                }
                if (!(response = request.eject(this, (IItemHandler)this.targetInventory.getCapability(), 0, LogisticalTransporterBase::getColor)).isEmpty() && this.tier != BinTier.CREATIVE) {
                    int sendingAmount = response.getSendingAmount();
                    MekanismUtils.logMismatchedStackSize(this.binSlot.shrinkStack(sendingAmount, Action.EXECUTE), sendingAmount);
                }
                this.delayTicks = 10;
            }
        } else {
            --this.delayTicks;
        }
        if (this.needsSync) {
            sendUpdatePacket = true;
            this.needsSync = false;
        }
        return sendUpdatePacket;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        this.setActive(!this.getActive());
        Level world = this.getLevel();
        if (world != null) {
            world.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean toggleLock() {
        return this.setLocked(!this.binSlot.isLocked());
    }

    public boolean setLocked(boolean isLocked) {
        if (this.binSlot.setLocked(isLocked)) {
            if (this.getLevel() != null && !this.isRemote()) {
                this.needsSync = true;
                this.markForSave();
                this.getLevel().playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof BinUpgradeData) {
            BinUpgradeData data = (BinUpgradeData)upgradeData;
            this.redstone = data.redstone();
            BinInventorySlot previous = data.binSlot();
            this.binSlot.setStack(previous.getStack());
            this.binSlot.setLockStack(previous.getLockStack());
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @Override
    @NotNull
    public BinUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new BinUpgradeData(this.redstone, this.getBinSlot());
    }

    @Override
    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.level != null && !this.isRemote()) {
            this.needsSync = true;
        }
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.put("item", (Tag)this.binSlot.serializeNBT(provider));
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setCompoundIfPresent(tag, "item", nbt -> this.binSlot.deserializeNBT(provider, (CompoundTag)nbt));
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        builder.set(MekanismDataComponents.LOCK, (Object)LockData.create(this.binSlot.getLockStack()));
        super.collectImplicitComponents(builder);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        this.binSlot.setLockStack(((LockData)input.getOrDefault(MekanismDataComponents.LOCK, (Object)LockData.EMPTY)).lock());
        super.applyImplicitComponents(input);
    }

    @ComputerMethod(methodDescription="Get the maximum number of items the bin can contain.")
    int getCapacity() {
        return this.binSlot.getLimit(this.binSlot.getStack());
    }

    @ComputerMethod(methodDescription="If true, the Bin is locked to a particular item type.")
    boolean isLocked() {
        return this.binSlot.isLocked();
    }

    @ComputerMethod(methodDescription="Get the type of item the Bin is locked to (or Air if not locked)")
    ItemStack getLock() {
        return this.binSlot.getLockStack();
    }

    @ComputerMethod(methodDescription="Lock the Bin to the currently stored item type. The Bin must not be creative, empty, or already locked")
    void lock() throws ComputerException {
        if (this.getTier() == BinTier.CREATIVE) {
            throw new ComputerException("Creative bins cannot be locked!");
        }
        if (this.binSlot.isEmpty()) {
            throw new ComputerException("Empty bins cannot be locked!");
        }
        if (!this.setLocked(true)) {
            throw new ComputerException("This bin is already locked!");
        }
    }

    @ComputerMethod(methodDescription="Unlock the Bin's fixed item type. The Bin must not be creative, or already unlocked")
    void unlock() throws ComputerException {
        if (this.getTier() == BinTier.CREATIVE) {
            throw new ComputerException("Creative bins cannot be unlocked!");
        }
        if (!this.setLocked(true)) {
            throw new ComputerException("This bin is not locked!");
        }
    }
}

