/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.resource;

import mekanism.common.resource.IResource;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public enum BlockResourceInfo implements IResource
{
    OSMIUM("osmium", 7.5f, 12.0f, MapColor.COLOR_CYAN),
    RAW_OSMIUM("raw_osmium", 7.5f, 12.0f, MapColor.COLOR_CYAN, NoteBlockInstrument.BASEDRUM),
    TIN("tin", 5.0f, 6.0f, MapColor.TERRACOTTA_WHITE),
    RAW_TIN("raw_tin", 5.0f, 6.0f, MapColor.TERRACOTTA_WHITE, NoteBlockInstrument.BASEDRUM),
    LEAD("lead", 5.0f, 9.0f, MapColor.COLOR_LIGHT_GRAY),
    RAW_LEAD("raw_lead", 5.0f, 9.0f, MapColor.COLOR_LIGHT_GRAY, NoteBlockInstrument.BASEDRUM),
    URANIUM("uranium", 5.0f, 9.0f, MapColor.GRASS),
    RAW_URANIUM("raw_uranium", 5.0f, 9.0f, MapColor.GRASS, NoteBlockInstrument.BASEDRUM),
    CHARCOAL("charcoal", 5.0f, 6.0f, MapColor.COLOR_BLACK, NoteBlockInstrument.BASEDRUM),
    FLUORITE("fluorite", 5.0f, 9.0f, MapColor.SNOW),
    BRONZE("bronze", 5.0f, 9.0f, MapColor.COLOR_ORANGE),
    STEEL("steel", 5.0f, 9.0f, MapColor.DEEPSLATE),
    REFINED_OBSIDIAN("refined_obsidian", 50.0f, 2400.0f, MapColor.COLOR_PURPLE, NoteBlockInstrument.BASEDRUM, 8, false, true, PushReaction.BLOCK),
    REFINED_GLOWSTONE("refined_glowstone", 5.0f, 6.0f, MapColor.COLOR_YELLOW, NoteBlockInstrument.BASEDRUM, 15);

    private final String registrySuffix;
    private final MapColor mapColor;
    private final PushReaction pushReaction;
    private final boolean portalFrame;
    private final boolean burnsInFire;
    private final NoteBlockInstrument instrument;
    private final float resistance;
    private final float hardness;
    private final int lightValue;

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, MapColor mapColor) {
        this(registrySuffix, hardness, resistance, mapColor, null);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, @Nullable float resistance, MapColor mapColor, NoteBlockInstrument instrument) {
        this(registrySuffix, hardness, resistance, mapColor, instrument, 0);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, @Nullable float resistance, MapColor mapColor, NoteBlockInstrument instrument, int lightValue) {
        this(registrySuffix, hardness, resistance, mapColor, instrument, lightValue, true, false, PushReaction.NORMAL);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, @Nullable float resistance, MapColor mapColor, NoteBlockInstrument instrument, int lightValue, boolean burnsInFire, boolean portalFrame, PushReaction pushReaction) {
        this.registrySuffix = registrySuffix;
        this.pushReaction = pushReaction;
        this.portalFrame = portalFrame;
        this.burnsInFire = burnsInFire;
        this.lightValue = lightValue;
        this.resistance = resistance;
        this.hardness = hardness;
        this.instrument = instrument;
        this.mapColor = mapColor;
    }

    @Override
    public String getRegistrySuffix() {
        return this.registrySuffix;
    }

    public boolean isPortalFrame() {
        return this.portalFrame;
    }

    public boolean burnsInFire() {
        return this.burnsInFire;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public BlockBehaviour.Properties modifyProperties(BlockBehaviour.Properties properties) {
        if (this.instrument != null) {
            properties.instrument(this.instrument);
        }
        return properties.mapColor(this.mapColor).strength(this.hardness, this.resistance).lightLevel(state -> this.lightValue).pushReaction(this.pushReaction);
    }
}

