/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.registries.MekanismRecipeSerializersInternal;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

@NothingNullByDefault
public class ClearConfigurationRecipe
extends CustomRecipe {
    private static final Set<Holder<DataComponentType<?>>> CLEARABLE_ATTACHMENTS = (Set)Util.make(new HashSet(), set -> {
        set.add(MekanismDataComponents.EDIT_MODE);
        set.add(MekanismDataComponents.DUMP_MODE);
        set.add(MekanismDataComponents.SECONDARY_DUMP_MODE);
        set.add(MekanismDataComponents.REDSTONE_CONTROL);
        set.add(MekanismDataComponents.REDSTONE_OUTPUT);
        set.add(MekanismDataComponents.COLOR);
        set.add(MekanismDataComponents.BUCKET_MODE);
        set.add(MekanismDataComponents.ROTARY_MODE);
        set.add(MekanismDataComponents.AUTO);
        set.add(MekanismDataComponents.SORTING);
        set.add(MekanismDataComponents.EJECT);
        set.add(MekanismDataComponents.PULL);
        set.add(MekanismDataComponents.ROUND_ROBIN);
        set.add(MekanismDataComponents.SINGLE_ITEM);
        set.add(MekanismDataComponents.FUZZY);
        set.add(MekanismDataComponents.SILK_TOUCH);
        set.add(MekanismDataComponents.INVERSE);
        set.add(MekanismDataComponents.INVERSE_REQUIRES_REPLACE);
        set.add(MekanismDataComponents.FROM_RECIPE);
        set.add(MekanismDataComponents.INSERT_INTO_FREQUENCY);
        set.add(MekanismDataComponents.RADIUS);
        set.add(MekanismDataComponents.MIN_Y);
        set.add(MekanismDataComponents.MAX_Y);
        set.add(MekanismDataComponents.DELAY);
        set.add(MekanismDataComponents.LONG_AMOUNT);
        set.add(MekanismDataComponents.MIN_THRESHOLD);
        set.add(MekanismDataComponents.MAX_THRESHOLD);
        set.add(MekanismDataComponents.EJECTOR);
        set.add(MekanismDataComponents.SIDE_CONFIG);
        set.add(MekanismDataComponents.REPLACE_STACK);
        set.add(MekanismDataComponents.ITEM_TARGET);
        set.add(MekanismDataComponents.STABILIZER_CHUNKS);
        set.add(MekanismDataComponents.FILTER_AWARE);
        set.add(MekanismDataComponents.CONFIGURATION_DATA);
        set.add(MekanismDataComponents.FORMULA_HOLDER);
        set.add(MekanismDataComponents.ATTACHED_HEAT);
    });

    @SafeVarargs
    public static void addAttachments(Holder<DataComponentType<?>> ... components) {
        Collections.addAll(CLEARABLE_ATTACHMENTS, components);
    }

    public ClearConfigurationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack target = this.getTargetStack(input);
        if (target.isEmpty()) {
            return false;
        }
        for (Holder<DataComponentType<?>> clearableAttachment : CLEARABLE_ATTACHMENTS) {
            if (!target.has((DataComponentType)clearableAttachment.value())) continue;
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack target = this.getTargetStack(input);
        if (target.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack output = target.copyWithCount(1);
        DataComponentMap prototype = output.getPrototype();
        for (Holder<DataComponentType<?>> clearableAttachment : CLEARABLE_ATTACHMENTS) {
            this.resetComponent(output, prototype, (DataComponentType)clearableAttachment.value());
        }
        return output;
    }

    private <TYPE> void resetComponent(ItemStack output, DataComponentMap prototype, DataComponentType<TYPE> componentType) {
        if (prototype.has(componentType)) {
            output.set(componentType, prototype.get(componentType));
        } else {
            output.remove(componentType);
        }
    }

    private ItemStack getTargetStack(CraftingInput input) {
        ItemStack target = ItemStack.EMPTY;
        int slots = input.size();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = input.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.isComponentsPatchEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!target.isEmpty()) {
                return ItemStack.EMPTY;
            }
            target = stackInSlot;
        }
        return target;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    public boolean isIncomplete() {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializersInternal.CLEAR_CONFIGURATION.get();
    }
}

