/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.tier.BaseTier;
import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.UseGaugeDropperTrigger;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketDropperUse(BlockPos pos, DropperAction action, TankType tankType, int tankId) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketDropperUse> TYPE = new CustomPacketPayload.Type(Mekanism.rl("use_dropper"));
    public static final StreamCodec<ByteBuf, PacketDropperUse> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketDropperUse::pos, DropperAction.STREAM_CODEC, PacketDropperUse::action, TankType.STREAM_CODEC, PacketDropperUse::tankType, (StreamCodec)ByteBufCodecs.VAR_INT, PacketDropperUse::tankId, PacketDropperUse::new);

    @NotNull
    public CustomPacketPayload.Type<PacketDropperUse> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player;
        if (this.tankId >= 0 && (player = context.player()) instanceof ServerPlayer) {
            TileEntityMekanism tile;
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack stack = player2.containerMenu.getCarried();
            if (!stack.isEmpty() && stack.getItem() instanceof ItemGaugeDropper && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player2.level(), this.pos)) != null) {
                if (tile instanceof TileEntityMultiblock) {
                    TileEntityMultiblock multiblock = (TileEntityMultiblock)tile;
                    MultiblockData structure = multiblock.getMultiblock();
                    if (structure.isFormed()) {
                        this.handleTankType(structure, player2, stack, GlobalPos.of((ResourceKey)player2.level().dimension(), (BlockPos)structure.getBounds().getCenter()));
                    }
                } else {
                    if (this.action == DropperAction.DUMP_TANK && !player2.isCreative() && Attribute.getBaseTier(tile.getBlockHolder()) == BaseTier.CREATIVE) {
                        return;
                    }
                    this.handleTankType(tile, player2, stack, tile.getTileGlobalPos());
                }
            }
        }
    }

    private <HANDLER extends IMekanismFluidHandler & IMekanismChemicalHandler> void handleTankType(HANDLER handler, ServerPlayer player, ItemStack stack, GlobalPos pos) {
        IChemicalTank chemicalTank;
        if (this.tankType == TankType.FLUID_TANK) {
            IExtendedFluidTank fluidTank = handler.getFluidTank(this.tankId, null);
            if (fluidTank != null) {
                this.handleFluidTank(player, stack, fluidTank);
            }
        } else if (this.tankType == TankType.CHEMICAL_TANK && (chemicalTank = ((IMekanismChemicalHandler)handler).getChemicalTank(this.tankId, null)) != null) {
            this.handleChemicalTank(player, stack, chemicalTank, pos);
        }
    }

    private void handleChemicalTank(ServerPlayer player, ItemStack stack, IChemicalTank tank, GlobalPos pos) {
        if (this.action == DropperAction.DUMP_TANK) {
            if (!tank.isEmpty()) {
                IRadiationManager.INSTANCE.dumpRadiation(pos, tank.getStack());
                tank.setEmpty();
                ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DUMP);
            }
        } else {
            IMekanismChemicalHandler chemicalHandler;
            IChemicalTank itemTank;
            IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
            if (handler instanceof IMekanismChemicalHandler && (itemTank = (chemicalHandler = (IMekanismChemicalHandler)handler).getChemicalTank(0, null)) != null) {
                if (this.action == DropperAction.FILL_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(tank, itemTank, (Player)player);
                    ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.FILL);
                } else if (this.action == DropperAction.DRAIN_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(itemTank, tank, (Player)player);
                    ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DRAIN);
                }
            }
        }
    }

    private void handleFluidTank(ServerPlayer player, ItemStack stack, IExtendedFluidTank fluidTank) {
        IMekanismFluidHandler fluidHandler;
        IExtendedFluidTank itemFluidTank;
        if (this.action == DropperAction.DUMP_TANK) {
            fluidTank.setEmpty();
            ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DUMP);
            return;
        }
        IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability(stack);
        if (fluidHandlerItem instanceof IMekanismFluidHandler && (itemFluidTank = (fluidHandler = (IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null)) != null) {
            if (this.action == DropperAction.FILL_DROPPER) {
                PacketDropperUse.transferBetweenTanks(fluidTank, itemFluidTank, (Player)player);
                ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.FILL);
            } else if (this.action == DropperAction.DRAIN_DROPPER) {
                PacketDropperUse.transferBetweenTanks(itemFluidTank, fluidTank, (Player)player);
                ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DRAIN);
            }
        }
    }

    private static void transferBetweenTanks(IChemicalTank drainTank, IChemicalTank fillTank, Player player) {
        ChemicalStack extractedChemical;
        long amount;
        ChemicalStack chemicalInDrainTank;
        ChemicalStack simulatedRemainder;
        long remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0L && (remainder = (simulatedRemainder = fillTank.insert(chemicalInDrainTank = drainTank.getStack(), Action.SIMULATE, AutomationType.MANUAL)).getAmount()) < (amount = chemicalInDrainTank.getAmount()) && !(extractedChemical = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(fillTank.insert(extractedChemical, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            player.containerMenu.synchronizeCarriedToRemote();
        }
    }

    private static void transferBetweenTanks(IExtendedFluidTank drainTank, IExtendedFluidTank fillTank, Player player) {
        FluidStack extractedFluid;
        int amount;
        FluidStack fluidInDrainTank;
        FluidStack simulatedRemainder;
        int remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0 && (remainder = (simulatedRemainder = fillTank.insert(fluidInDrainTank = drainTank.getFluid(), Action.SIMULATE, AutomationType.MANUAL)).getAmount()) < (amount = fluidInDrainTank.getAmount()) && !(extractedFluid = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(fillTank.insert(extractedFluid, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            player.containerMenu.synchronizeCarriedToRemote();
        }
    }

    public static enum DropperAction {
        FILL_DROPPER,
        DRAIN_DROPPER,
        DUMP_TANK;

        public static final IntFunction<DropperAction> BY_ID;
        public static final StreamCodec<ByteBuf, DropperAction> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DropperAction.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static enum TankType {
        CHEMICAL_TANK,
        FLUID_TANK;

        public static final IntFunction<TankType> BY_ID;
        public static final StreamCodec<ByteBuf, TankType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])TankType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

