/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation.capability;

import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.MekanismDamageTrigger;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismDamageTypes;
import mekanism.common.util.MekanismUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;

public class RadiationEntity
implements IRadiationEntity {
    private final LivingEntity entity;

    public RadiationEntity(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public double getRadiation() {
        return (Double)this.entity.getData(MekanismAttachmentTypes.RADIATION);
    }

    @Override
    public void radiate(double magnitude) {
        if (magnitude > 0.0) {
            this.entity.setData(MekanismAttachmentTypes.RADIATION, (Object)(this.getRadiation() + magnitude));
        }
    }

    @Override
    public void update() {
        Player player;
        LivingEntity livingEntity;
        if (!this.entity.isAlive() || (livingEntity = this.entity) instanceof Player && !MekanismUtils.isPlayingMode(player = (Player)livingEntity)) {
            return;
        }
        double radiation = this.getRadiation();
        double severityScale = RadiationManager.RadiationScale.getScaledDoseSeverity(radiation);
        if (severityScale <= IRadiationManager.INSTANCE.baselineRadiation()) {
            return;
        }
        RandomSource rand = this.entity.level().getRandom();
        double minSeverity = MekanismConfig.general.radiationNegativeEffectsMinSeverity.get();
        double chance = minSeverity + rand.nextDouble() * (1.0 - minSeverity);
        if (severityScale > chance) {
            ServerPlayer player2;
            LivingEntity livingEntity2;
            float strength = Math.max(1.0f, (float)Math.log1p(radiation));
            if (rand.nextBoolean()) {
                livingEntity2 = this.entity;
                if (livingEntity2 instanceof ServerPlayer) {
                    player2 = (ServerPlayer)livingEntity2;
                    MinecraftServer server = this.entity.getServer();
                    int totemTimesUsed = -1;
                    if (server != null && server.isHardcore()) {
                        totemTimesUsed = player2.getStats().getValue(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING));
                    }
                    if (this.entity.hurt(MekanismDamageTypes.RADIATION.source(this.entity.level()), strength)) {
                        boolean hardcoreTotem = totemTimesUsed != -1 && totemTimesUsed < player2.getStats().getValue(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING));
                        ((MekanismDamageTrigger)((Object)MekanismCriteriaTriggers.DAMAGE.value())).trigger(player2, MekanismDamageTypes.RADIATION, hardcoreTotem);
                    }
                } else {
                    this.entity.hurt(MekanismDamageTypes.RADIATION.source(this.entity.level()), strength);
                }
            }
            if ((livingEntity2 = this.entity) instanceof ServerPlayer) {
                player2 = (ServerPlayer)livingEntity2;
                player2.getFoodData().addExhaustion(strength);
            }
        }
    }

    @Override
    public void set(double magnitude) {
        this.entity.setData(MekanismAttachmentTypes.RADIATION, (Object)Math.max(IRadiationManager.INSTANCE.baselineRadiation(), magnitude));
    }

    @Override
    public void decay() {
        this.set(this.getRadiation() * MekanismConfig.general.radiationTargetDecayRate.get());
    }
}

