/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.DecomposedRecipeBuilder;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class MekanismRecipeHandler<RECIPE extends MekanismRecipe<?>>
implements IRecipeHandler<RECIPE> {
    protected static final Object SKIP_OPTIONAL_PARAM = new Object();

    public abstract <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super RECIPE> var1, RECIPE var2, U var3);

    protected <TYPE, INGREDIENT extends InputIngredient<TYPE>> boolean ingredientConflicts(INGREDIENT a, INGREDIENT b) {
        return a.getRepresentations().stream().anyMatch(b::testType);
    }

    protected boolean chemicalIngredientConflicts(ChemicalStackIngredient a, ChemicalStackIngredient b) {
        return this.ingredientConflicts(a, b);
    }

    protected String buildCommandString(IRecipeManager<? super RECIPE> manager, RecipeHolder<RECIPE> recipe, Object ... params) {
        return this.buildCommandString(manager, "addRecipe", recipe, params);
    }

    protected String buildCommandString(IRecipeManager<? super RECIPE> manager, String method, RecipeHolder<RECIPE> recipe, Object ... params) {
        StringBuilder commandString = new StringBuilder(manager.getCommandString()).append('.').append(method).append("(\"").append(recipe.id().getPath()).append('\"');
        for (Object param : params) {
            if (param == SKIP_OPTIONAL_PARAM) continue;
            commandString.append(", ").append(this.convertParam(param));
        }
        return commandString.append(");").toString();
    }

    private String convertParam(Object param) {
        if (param instanceof CommandStringDisplayable) {
            CommandStringDisplayable displayable = (CommandStringDisplayable)param;
            return displayable.getCommandString();
        }
        if (param instanceof ItemStack) {
            ItemStack stack = (ItemStack)param;
            return ItemStackUtil.getCommandString((ItemStack)stack);
        }
        if (param instanceof FluidStack) {
            FluidStack stack = (FluidStack)param;
            return IFluidStack.of((Object)stack).getCommandString();
        }
        if (param instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)param;
            return new CrTChemicalStack(stack).getCommandString();
        }
        if (param instanceof Number || param instanceof Boolean) {
            return param.toString();
        }
        if (param instanceof ItemStackIngredient) {
            ItemStackIngredient ingredient = (ItemStackIngredient)param;
            return this.convertParam(CrTUtils.toCrT(ingredient));
        }
        if (param instanceof FluidStackIngredient) {
            FluidStackIngredient ingredient = (FluidStackIngredient)param;
            return this.convertParam(CrTUtils.toCrT(ingredient));
        }
        if (param instanceof ChemicalStackIngredient) {
            ChemicalStackIngredient ingredient = (ChemicalStackIngredient)param;
            return MekanismRecipeHandler.convertChemicalIngredient(ingredient.ingredient(), ingredient.amount());
        }
        if (param instanceof List) {
            List list = (List)param;
            if (list.isEmpty()) {
                return "Invalid (output) list, no outputs";
            }
            return this.convertParam(list.getFirst());
        }
        if (param instanceof long[]) {
            long[] longs = (long[])param;
            if (longs.length == 0) {
                return "Invalid (output) array, no outputs";
            }
            return this.convertParam(longs[0]);
        }
        if (param instanceof ElectrolysisRecipe.ElectrolysisRecipeOutput) {
            ElectrolysisRecipe.ElectrolysisRecipeOutput output = (ElectrolysisRecipe.ElectrolysisRecipeOutput)param;
            return this.convertParam(output.left()) + ", " + this.convertParam(output.right());
        }
        return "Unimplemented: " + String.valueOf(param);
    }

    private static String convertChemicalIngredient(ChemicalIngredient ingredient, long amount) {
        if (ingredient instanceof TagChemicalIngredient) {
            TagChemicalIngredient tagIngredient = (TagChemicalIngredient)ingredient;
            KnownTag tag = (KnownTag)CrTUtils.chemicalTags().tag(tagIngredient.tag());
            if (amount == 1L) {
                return tag.getCommandString();
            }
            if (amount > 0L && amount <= Integer.MAX_VALUE) {
                return tag.withAmount((int)amount).getCommandString();
            }
            return "mods.mekanism.api.ingredient.ChemicalStackIngredient.from(" + tag.getCommandString() + ", " + amount + ")";
        }
        ArrayList<ICrTChemicalStack> list = new ArrayList<ICrTChemicalStack>();
        for (Holder<Chemical> chemical : ingredient.getChemicalHolders()) {
            list.add(CrTUtils.fromChemical(chemical, 1));
        }
        if (list.size() == 1) {
            return ((ICrTChemicalStack)list.getFirst()).setAmount(amount).getCommandString();
        }
        String representation = list.stream().map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(", "));
        return "mods.mekanism.api.ingredient.ChemicalStackIngredient.from(" + amount + ", " + representation + ")";
    }

    protected Optional<IDecomposedRecipe> decompose(Object ... importantData) {
        TypeData<IIngredientWithAmount, CTFluidIngredient, ChemicalStackIngredient> inputs = new TypeData<IIngredientWithAmount, CTFluidIngredient, ChemicalStackIngredient>();
        TypeData<IItemStack, IFluidStack, ChemicalStack> outputs = new TypeData<IItemStack, IFluidStack, ChemicalStack>();
        int duration = -1;
        long energy = -1L;
        Boolean perTickUsage = null;
        for (Object data : importantData) {
            if (data instanceof List) {
                List dataList = (List)data;
                if (dataList.size() != 1) {
                    return Optional.empty();
                }
                data = dataList.getFirst();
            } else if (data instanceof long[]) {
                long[] longs = (long[])data;
                if (longs.length != 1) {
                    return Optional.empty();
                }
                data = longs[0];
            }
            if (data instanceof ItemStackIngredient) {
                ItemStackIngredient ingredient = (ItemStackIngredient)data;
                inputs.addItem(CrTUtils.toCrT(ingredient));
                continue;
            }
            if (data instanceof FluidStackIngredient) {
                FluidStackIngredient ingredient = (FluidStackIngredient)data;
                inputs.addFluid(CrTUtils.toCrT(ingredient));
                continue;
            }
            if (data instanceof ChemicalStackIngredient) {
                ChemicalStackIngredient ingredient = (ChemicalStackIngredient)data;
                inputs.addChemical(ingredient);
                continue;
            }
            if (data instanceof ItemStack) {
                ItemStack stack = (ItemStack)data;
                outputs.addItem(IItemStack.of((ItemStack)stack));
                continue;
            }
            if (data instanceof FluidStack) {
                FluidStack stack = (FluidStack)data;
                outputs.addFluid(IFluidStack.of((Object)stack));
                continue;
            }
            if (data instanceof ChemicalStack) {
                ChemicalStack stack = (ChemicalStack)data;
                outputs.addChemical(stack);
                continue;
            }
            if (data instanceof PressurizedReactionRecipe.PressurizedReactionRecipeOutput) {
                PressurizedReactionRecipe.PressurizedReactionRecipeOutput output = (PressurizedReactionRecipe.PressurizedReactionRecipeOutput)data;
                if (!output.item().isEmpty()) {
                    outputs.addItem(IItemStack.of((ItemStack)output.item()));
                }
                if (output.chemical().isEmpty()) continue;
                outputs.addChemical(output.chemical());
                continue;
            }
            if (data instanceof ElectrolysisRecipe.ElectrolysisRecipeOutput) {
                ElectrolysisRecipe.ElectrolysisRecipeOutput output = (ElectrolysisRecipe.ElectrolysisRecipeOutput)data;
                outputs.addChemical(output.left());
                outputs.addChemical(output.right());
                continue;
            }
            if (data instanceof Boolean) {
                Boolean b = (Boolean)data;
                if (perTickUsage != null) {
                    return Optional.empty();
                }
                perTickUsage = b;
                continue;
            }
            if (data instanceof Integer) {
                Integer i = (Integer)data;
                if (duration != -1) {
                    return Optional.empty();
                }
                duration = i;
                continue;
            }
            if (data instanceof Long) {
                Long l = (Long)data;
                if (energy != -1L) {
                    return Optional.empty();
                }
                energy = l;
                continue;
            }
            return Optional.empty();
        }
        DecomposedRecipeBuilder builder = IDecomposedRecipe.builder();
        inputs.addItemToBuilder(builder, CrTRecipeComponents.ITEM.input()).addFluidToBuilder(builder, CrTRecipeComponents.FLUID.input()).addChemicalToBuilder(builder, CrTRecipeComponents.CHEMICAL.input());
        outputs.addItemToBuilder(builder, CrTRecipeComponents.ITEM.output()).addFluidToBuilder(builder, CrTRecipeComponents.FLUID.output());
        if (!outputs.chemicalData.isEmpty()) {
            builder.with(CrTRecipeComponents.CHEMICAL.output(), CrTUtils.convertChemical(outputs.chemicalData));
        }
        if (duration != -1) {
            builder.with(BuiltinRecipeComponents.Processing.TIME, (Object)duration);
        }
        if (energy != -1L) {
            builder.with(CrTRecipeComponents.ENERGY, (Object)energy);
        }
        if (perTickUsage != null) {
            builder.with(CrTRecipeComponents.PER_TICK_USAGE, perTickUsage);
        }
        return Optional.of(builder.build());
    }

    private static class TypeData<ITEM, FLUID, CHEMICAL> {
        private final List<ITEM> itemData = new ArrayList<ITEM>();
        private final List<FLUID> fluidData = new ArrayList<FLUID>();
        private final List<CHEMICAL> chemicalData = new ArrayList<CHEMICAL>();

        private TypeData() {
        }

        private void addItem(ITEM data) {
            this.itemData.add(data);
        }

        private void addFluid(FLUID data) {
            this.fluidData.add(data);
        }

        private void addChemical(CHEMICAL data) {
            this.chemicalData.add(data);
        }

        private TypeData<ITEM, FLUID, CHEMICAL> addItemToBuilder(DecomposedRecipeBuilder builder, IRecipeComponent<ITEM> component) {
            if (!this.itemData.isEmpty()) {
                builder.with(component, this.itemData);
            }
            return this;
        }

        private TypeData<ITEM, FLUID, CHEMICAL> addFluidToBuilder(DecomposedRecipeBuilder builder, IRecipeComponent<FLUID> component) {
            if (!this.fluidData.isEmpty()) {
                builder.with(component, this.fluidData);
            }
            return this;
        }

        private TypeData<ITEM, FLUID, CHEMICAL> addChemicalToBuilder(DecomposedRecipeBuilder builder, IRecipeComponent<CHEMICAL> component) {
            if (!this.chemicalData.isEmpty()) {
                builder.with(component, this.chemicalData);
            }
            return this;
        }
    }
}

