/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import java.util.Collections;
import java.util.List;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.filter.GuiFilter;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerGhostTarget;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiItemStackFilter<FILTER extends IItemStackFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiFilter<FILTER, TILE> {
    protected GuiItemStackFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, @Nullable FILTER origFilter) {
        super(gui, x, y, width, height, (Component)MekanismLang.ITEM_FILTER.translate(), tile, origFilter);
    }

    @Override
    protected List<Component> getScreenText() {
        List<Component> list = super.getScreenText();
        if (((IItemStackFilter)this.filter).hasFilter()) {
            list.add(((IItemStackFilter)this.filter).getItemStack().getHoverName());
        }
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.ITEM_FILTER_NO_ITEM;
    }

    @Override
    @NotNull
    protected List<ItemStack> getRenderStacks() {
        ItemStack stack = ((IItemStackFilter)this.filter).getItemStack();
        return stack.isEmpty() ? Collections.emptyList() : Collections.singletonList(stack);
    }

    @Override
    @Nullable
    protected IRecipeViewerGhostTarget.IGhostItemConsumer getGhostHandler() {
        return ingredient -> this.setFilterStackWithSound(((ItemStack)ingredient).copyWithCount(1));
    }

    @Override
    @Nullable
    protected GuiElement.IClickable getSlotClickHandler() {
        return GuiItemStackFilter.getHandleClickSlot(NOT_EMPTY, this::setFilterStack);
    }

    private void setFilterStack(@NotNull ItemStack stack) {
        ((IItemStackFilter)this.filter).setItemStack(stack);
        this.slotDisplay.updateStackList();
    }

    protected void setFilterStackWithSound(@NotNull ItemStack stack) {
        this.setFilterStack(stack);
        GuiItemStackFilter.playClickSound(BUTTON_CLICK_SOUND);
    }
}

