/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.radial.RadialData;
import mekanism.client.MekanismClient;
import mekanism.client.gui.GuiRadialSelector;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.hud.MekanismStatusOverlay;
import mekanism.client.render.lib.ScrollIncrementer;
import mekanism.client.sound.GeigerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.holiday.HolidayManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemHDPEElytra;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketModeChange;
import mekanism.common.network.to_server.PacketPortableTeleporterTeleport;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.ArmorStandModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FogType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class ClientTickHandler {
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static final RandomSource rand = RandomSource.create();
    private static final Map<Player, TeleportData> portableTeleports = new Object2ObjectArrayMap(1);
    private static final ScrollIncrementer scrollIncrementer = new ScrollIncrementer(true);
    private static boolean visionEnhancement = false;
    private boolean isConnected;

    public static void reset() {
        portableTeleports.clear();
        visionEnhancement = false;
    }

    public static boolean isJetpackInUse(Player player, ItemStack jetpack) {
        if (!player.isSpectator() && !jetpack.isEmpty()) {
            boolean rising;
            IJetpackItem.JetpackMode mode = ((IJetpackItem)jetpack.getItem()).getJetpackMode(jetpack);
            boolean guiOpen = ClientTickHandler.minecraft.screen != null;
            boolean ascending = ClientTickHandler.minecraft.player.input.jumping;
            boolean bl = rising = ascending && !guiOpen;
            if (mode == IJetpackItem.JetpackMode.NORMAL || mode == IJetpackItem.JetpackMode.VECTOR) {
                return rising;
            }
            if (mode == IJetpackItem.JetpackMode.HOVER) {
                boolean descending = ClientTickHandler.minecraft.player.input.shiftKeyDown;
                if (!rising || descending) {
                    return !CommonPlayerTickHandler.isOnGroundOrSleeping(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isScubaMaskOn(Player player) {
        if (player != ClientTickHandler.minecraft.player) {
            return Mekanism.playerState.isScubaMaskOn(player);
        }
        return CommonPlayerTickHandler.isScubaMaskOn(player, player.getItemBySlot(EquipmentSlot.CHEST));
    }

    public static boolean isGravitationalModulationOn(Player player) {
        if (player != ClientTickHandler.minecraft.player) {
            return Mekanism.playerState.isGravitationalModulationOn(player);
        }
        return CommonPlayerTickHandler.isGravitationalModulationOn(player);
    }

    public static boolean isVisionEnhancementOn(Player player) {
        IModuleContainer container;
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!player.getCooldowns().isOnCooldown(head.getItem()) && (container = IModuleHelper.INSTANCE.getModuleContainer(head)) != null) {
            IModule module = container.getIfEnabled(MekanismModules.VISION_ENHANCEMENT_UNIT);
            return module != null && module.hasEnoughEnergy(head, MekanismConfig.gear.mekaSuitEnergyUsageVisionEnhancement);
        }
        return false;
    }

    public static void portableTeleport(Player player, InteractionHand hand, Frequency.FrequencyIdentity identity) {
        int delay = MekanismConfig.gear.portableTeleporterDelay.get();
        if (delay == 0) {
            PacketUtils.sendToServer(new PacketPortableTeleporterTeleport(hand, identity));
        } else {
            portableTeleports.put(player, new TeleportData(hand, identity, ClientTickHandler.minecraft.level.getGameTime() + (long)delay));
        }
    }

    @SubscribeEvent
    public void onStartTracking(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().isClientSide && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startFlamethrowerSound(player);
            }
        }
    }

    @SubscribeEvent
    public void onJoinServer(ClientPlayerNetworkEvent.LoggingIn event) {
        if (!this.isConnected) {
            this.isConnected = true;
            MekanismClient.launchClient(event.getConnection());
        }
    }

    @SubscribeEvent
    public void onLeaveServer(ClientPlayerNetworkEvent.LoggingOut event) {
        if (this.isConnected) {
            this.isConnected = false;
            MekanismClient.reset();
        }
    }

    @SubscribeEvent
    public void onTick(ClientTickEvent.Pre event) {
        RadiationManager.RadiationScale scale;
        Object primaryJetpack;
        if (ClientTickHandler.minecraft.level == null || ClientTickHandler.minecraft.player == null) {
            return;
        }
        boolean tickingNormally = MekanismRenderer.isRunningNormally();
        HolidayManager.notify((Player)ClientTickHandler.minecraft.player);
        SoundHandler.restartSounds();
        if (tickingNormally) {
            RadiationManager.get().tickClient((Player)ClientTickHandler.minecraft.player);
        }
        UUID playerUUID = ClientTickHandler.minecraft.player.getUUID();
        ItemStack jetpack = IJetpackItem.getActiveJetpack((LivingEntity)ClientTickHandler.minecraft.player);
        boolean jetpackInUse = ClientTickHandler.isJetpackInUse((Player)ClientTickHandler.minecraft.player, jetpack);
        Mekanism.playerState.setJetpackState(playerUUID, jetpackInUse, true);
        Mekanism.playerState.setScubaMaskState(playerUUID, ClientTickHandler.isScubaMaskOn((Player)ClientTickHandler.minecraft.player), true);
        Mekanism.playerState.setGravitationalModulationState(playerUUID, ClientTickHandler.isGravitationalModulationOn((Player)ClientTickHandler.minecraft.player), true);
        if (tickingNormally) {
            Iterator<Map.Entry<Player, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Player, TeleportData> entry = iter.next();
                Player player = entry.getKey();
                for (int i = 0; i < 100; ++i) {
                    double x = player.getX() + rand.nextDouble() - 0.5;
                    double y = player.getY() + rand.nextDouble() * 2.0 - 2.0;
                    double z = player.getZ() + rand.nextDouble() - 0.5;
                    ClientTickHandler.minecraft.level.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 0.0, 1.0, 0.0);
                }
                TeleportData data = entry.getValue();
                if (ClientTickHandler.minecraft.level.getGameTime() != data.teleportTime) continue;
                PacketUtils.sendToServer(new PacketPortableTeleporterTeleport(data.hand, data.identity));
                iter.remove();
            }
        }
        if (!jetpack.isEmpty() && !(primaryJetpack = IJetpackItem.getPrimaryJetpack((LivingEntity)ClientTickHandler.minecraft.player)).isEmpty()) {
            IJetpackItem.JetpackMode primaryMode = ((IJetpackItem)primaryJetpack.getItem()).getJetpackMode((ItemStack)primaryJetpack);
            IJetpackItem.JetpackMode mode = IJetpackItem.getPlayerJetpackMode(ClientTickHandler.minecraft.player, primaryMode, p -> p.input.jumping);
            MekanismClient.updateKey(ClientTickHandler.minecraft.player.input.jumping, 0);
            double jetpackThrust = ((IJetpackItem)primaryJetpack.getItem()).getJetpackThrust((ItemStack)primaryJetpack);
            if (jetpackInUse && IJetpackItem.handleJetpackMotion(ClientTickHandler.minecraft.player, mode, jetpackThrust, p -> p.input.jumping)) {
                ClientTickHandler.minecraft.player.resetFallDistance();
            }
        }
        if (ClientTickHandler.isScubaMaskOn((Player)ClientTickHandler.minecraft.player) && ClientTickHandler.minecraft.player.getAirSupply() == ClientTickHandler.minecraft.player.getMaxAirSupply()) {
            for (MobEffectInstance effect : ClientTickHandler.minecraft.player.getActiveEffects()) {
                if (!MekanismUtils.shouldSpeedUpEffect(effect)) continue;
                for (int i = 0; i < 9; ++i) {
                    MekanismUtils.speedUpEffectSafely((LivingEntity)ClientTickHandler.minecraft.player, effect);
                }
            }
        }
        if (ClientTickHandler.isVisionEnhancementOn((Player)ClientTickHandler.minecraft.player)) {
            visionEnhancement = true;
            ClientTickHandler.minecraft.player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 220, 0, false, false, false));
        } else if (visionEnhancement) {
            visionEnhancement = false;
            MobEffectInstance effect = ClientTickHandler.minecraft.player.getEffect(MobEffects.NIGHT_VISION);
            if (effect != null && effect.getDuration() <= 220) {
                ClientTickHandler.minecraft.player.removeEffect(MobEffects.NIGHT_VISION);
            }
        }
        if (!(ClientTickHandler.minecraft.screen != null && !(ClientTickHandler.minecraft.screen instanceof GuiRadialSelector) || MekKeyHandler.isRadialPressed() && (this.updateSelectorRenderer(EquipmentSlot.MAINHAND) || this.updateSelectorRenderer(EquipmentSlot.OFFHAND)) || ClientTickHandler.minecraft.screen == null)) {
            minecraft.setScreen(null);
        }
        if (tickingNormally && MekanismConfig.client.enablePlayerSounds.get() && (scale = RadiationManager.get().getClientScale()) != RadiationManager.RadiationScale.NONE && !SoundHandler.radiationSoundMap.containsKey((Object)scale)) {
            GeigerSound sound = GeigerSound.create((Player)ClientTickHandler.minecraft.player, scale);
            SoundHandler.radiationSoundMap.put(scale, sound);
            SoundHandler.playSound((SoundInstance)sound);
        }
    }

    private boolean updateSelectorRenderer(EquipmentSlot slot) {
        IGenericRadialModeItem item;
        RadialData<?> radialData;
        ItemStack stack;
        Item item2;
        if (ClientTickHandler.minecraft.player != null && (item2 = (stack = ClientTickHandler.minecraft.player.getItemBySlot(slot)).getItem()) instanceof IGenericRadialModeItem && (radialData = (item = (IGenericRadialModeItem)item2).getRadialData(stack)) != null) {
            GuiRadialSelector screen;
            Screen screen2 = ClientTickHandler.minecraft.screen;
            if (!(screen2 instanceof GuiRadialSelector) || !(screen = (GuiRadialSelector)screen2).hasMatchingData(slot, radialData)) {
                GuiRadialSelector newSelector = new GuiRadialSelector(slot, radialData, () -> ClientTickHandler.minecraft.player);
                newSelector.tryInheritCurrentPath(ClientTickHandler.minecraft.screen);
                minecraft.setScreen((Screen)newSelector);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        double delta;
        if (MekanismConfig.client.allowModeScroll.get() && ClientTickHandler.minecraft.player != null && ClientTickHandler.minecraft.player.isShiftKeyDown() && (delta = event.getScrollDeltaY()) != 0.0 && IModeItem.isModeItem((Player)ClientTickHandler.minecraft.player, EquipmentSlot.MAINHAND)) {
            int shift = scrollIncrementer.scroll(delta);
            if (shift != 0) {
                MekanismStatusOverlay.INSTANCE.setTimer();
                PacketUtils.sendToServer(new PacketModeChange(EquipmentSlot.MAINHAND, shift));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFogLighting(ViewportEvent.ComputeFogColor event) {
        if (visionEnhancement) {
            float oldRatio = 0.1f;
            float newRatio = 1.0f - oldRatio;
            float red = oldRatio * event.getRed();
            float green = oldRatio * event.getGreen();
            float blue = oldRatio * event.getBlue();
            event.setRed(red + newRatio * 0.4f);
            event.setGreen(green + newRatio * 0.8f);
            event.setBlue(blue + newRatio * 0.4f);
        }
    }

    @SubscribeEvent
    public void onFog(ViewportEvent.RenderFog event) {
        Player player;
        IModule module;
        Entity entity;
        if (visionEnhancement && (entity = event.getCamera().getEntity()) instanceof Player && (module = IModuleHelper.INSTANCE.getIfEnabled((LivingEntity)(player = (Player)entity), EquipmentSlot.HEAD, MekanismModules.VISION_ENHANCEMENT_UNIT)) != null) {
            event.setNearPlaneDistance(-8.0f);
            if (event.getFarPlaneDistance() < 20.0f) {
                float scalar = event.getType() == FogType.LAVA ? 24.0f * event.getFarPlaneDistance() : 5.0f + 2.5f * (float)Math.pow(Math.E, 0.16f * event.getFarPlaneDistance());
                event.setFarPlaneDistance(Math.min(192.0f, scalar));
            }
            event.scaleFarPlaneDistance((float)Math.pow(module.getInstalledCount(), 1.25) / (float)module.getUntypedData().getMaxStackSize());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void recipesUpdated(RecipesUpdatedEvent event) {
        MekanismRecipeType.clearCache();
    }

    @SubscribeEvent
    public void renderEntityPre(RenderLivingEvent.Pre<?, ?> evt) {
        EntityModel model = evt.getRenderer().getModel();
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ClientTickHandler.setModelVisibility(evt.getEntity(), humanoidModel, false);
        }
    }

    @SubscribeEvent
    public void renderEntityPost(RenderLivingEvent.Post<?, ?> evt) {
        EntityModel model = evt.getRenderer().getModel();
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ClientTickHandler.setModelVisibility(evt.getEntity(), humanoidModel, true);
        }
    }

    private static void setModelVisibility(LivingEntity entity, HumanoidModel<?> entityModel, boolean showModel) {
        PlayerModel playerModel;
        ItemStack chest;
        if (entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ItemMekaSuitArmor) {
            entityModel.head.visible = showModel;
            entityModel.hat.visible = showModel;
            if (entityModel instanceof PlayerModel) {
                PlayerModel playerModel2 = (PlayerModel)entityModel;
                playerModel2.ear.visible = showModel;
            }
        }
        if ((chest = entity.getItemBySlot(EquipmentSlot.CHEST)).getItem() instanceof ItemMekaSuitArmor) {
            entityModel.body.visible = showModel;
            if (!(entity instanceof ArmorStand)) {
                entityModel.leftArm.visible = showModel;
                entityModel.rightArm.visible = showModel;
            }
            if (entityModel instanceof PlayerModel) {
                PlayerModel playerModel3 = (PlayerModel)entityModel;
                playerModel3.cloak.visible = showModel;
                playerModel3.jacket.visible = showModel;
                playerModel3.leftSleeve.visible = showModel;
                playerModel3.rightSleeve.visible = showModel;
            } else if (entityModel instanceof ArmorStandModel) {
                ArmorStandModel armorStandModel = (ArmorStandModel)entityModel;
                armorStandModel.rightBodyStick.visible = showModel;
                armorStandModel.leftBodyStick.visible = showModel;
                armorStandModel.shoulderStick.visible = showModel;
            }
        } else if (ClientTickHandler.itemHidesCape(chest.getItem()) && entityModel instanceof PlayerModel) {
            playerModel = (PlayerModel)entityModel;
            playerModel.cloak.visible = showModel;
        }
        if (entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ItemMekaSuitArmor) {
            entityModel.leftLeg.visible = showModel;
            entityModel.rightLeg.visible = showModel;
            if (entityModel instanceof PlayerModel) {
                playerModel = (PlayerModel)entityModel;
                playerModel.leftPants.visible = showModel;
                playerModel.rightPants.visible = showModel;
            }
        }
    }

    private static boolean itemHidesCape(Item item) {
        return item instanceof ItemHDPEElytra || item instanceof ItemJetpack || item instanceof ItemScubaTank;
    }

    private record TeleportData(InteractionHand hand, Frequency.FrequencyIdentity identity, long teleportTime) {
    }
}

