/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicWashingRecipe
extends FluidChemicalToChemicalRecipe {
    private static final Holder<Item> CHEMICAL_WASHER = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_washer"));
    protected final FluidStackIngredient fluidInput;
    protected final ChemicalStackIngredient chemicalInput;
    protected final ChemicalStack output;

    public BasicWashingRecipe(FluidStackIngredient fluidInput, ChemicalStackIngredient chemicalInput, ChemicalStack output) {
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    public final RecipeType<FluidChemicalToChemicalRecipe> getType() {
        return (RecipeType)MekanismRecipeTypes.TYPE_WASHING.value();
    }

    public String getGroup() {
        return "chemical_washer";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(CHEMICAL_WASHER);
    }

    @Override
    public boolean test(FluidStack fluidStack, ChemicalStack chemicalStack) {
        return this.fluidInput.test(fluidStack) && this.chemicalInput.test(chemicalStack);
    }

    @Override
    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    @Override
    public ChemicalStackIngredient getChemicalInput() {
        return this.chemicalInput;
    }

    @Override
    public List<ChemicalStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public ChemicalStack getOutput(FluidStack fluidStack, ChemicalStack chemicalStack) {
        return this.output.copy();
    }

    public ChemicalStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicWashingRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.WASHING.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicWashingRecipe other = (BasicWashingRecipe)o;
        return this.fluidInput.equals(other.fluidInput) && this.chemicalInput.equals(other.chemicalInput) && this.output.equals(other.output);
    }

    public int hashCode() {
        return Objects.hash(this.fluidInput, this.chemicalInput, this.output);
    }
}

