/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ItemStackToChemicalRecipe;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class BasicItemStackToChemicalRecipe
extends ItemStackToChemicalRecipe
implements IBasicChemicalOutput {
    protected final ItemStackIngredient input;
    protected final ChemicalStack output;
    private final RecipeType<ItemStackToChemicalRecipe> recipeType;

    public BasicItemStackToChemicalRecipe(ItemStackIngredient input, ChemicalStack output, RecipeType<ItemStackToChemicalRecipe> recipeType) {
        this.recipeType = Objects.requireNonNull(recipeType, "Recipe type cannot be null");
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.input.test(itemStack);
    }

    @Override
    public ItemStackIngredient getInput() {
        return this.input;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public ChemicalStack getOutput(ItemStack input) {
        return this.output.copy();
    }

    @Override
    public List<ChemicalStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public ChemicalStack getOutputRaw() {
        return this.output;
    }

    public final RecipeType<ItemStackToChemicalRecipe> getType() {
        return this.recipeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicItemStackToChemicalRecipe other = (BasicItemStackToChemicalRecipe)o;
        return this.input.equals(other.input) && this.output.equals(other.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output);
    }
}

