/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import java.util.ServiceLoader;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.gear.ModuleData;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.robit.RobitSkin;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@NothingNullByDefault
public class MekanismAPI {
    public static final String API_VERSION = "10.7.11";
    public static final String MEKANISM_MODID = "mekanism";
    public static boolean debug = false;
    public static final Logger logger = LogUtils.getLogger();
    public static final ResourceKey<Registry<Chemical>> CHEMICAL_REGISTRY_NAME = MekanismAPI.registryKey(Chemical.class, "chemical");
    public static final ResourceKey<Chemical> EMPTY_CHEMICAL_KEY = ResourceKey.create(CHEMICAL_REGISTRY_NAME, (ResourceLocation)MekanismAPI.rl("empty"));
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final ResourceLocation EMPTY_CHEMICAL_NAME = EMPTY_CHEMICAL_KEY.location();
    public static final ResourceKey<Registry<MapCodec<? extends ChemicalIngredient>>> CHEMICAL_INGREDIENT_TYPE_REGISTRY_NAME = MekanismAPI.codecRegistryKey(ChemicalIngredient.class, "chemical_ingredient_type");
    public static final ResourceKey<Registry<ModuleData<?>>> MODULE_REGISTRY_NAME = MekanismAPI.registryKey(ModuleData.class, "module");
    public static final ResourceKey<Registry<RobitSkin>> ROBIT_SKIN_REGISTRY_NAME = MekanismAPI.registryKey(RobitSkin.class, "robit_skin");
    public static final ResourceKey<Registry<MapCodec<? extends RobitSkin>>> ROBIT_SKIN_SERIALIZER_REGISTRY_NAME = MekanismAPI.codecRegistryKey(RobitSkin.class, "robit_skin_serializer");
    public static final DefaultedRegistry<Chemical> CHEMICAL_REGISTRY = (DefaultedRegistry)new RegistryBuilder(CHEMICAL_REGISTRY_NAME).defaultKey(EMPTY_CHEMICAL_KEY).sync(true).withIntrusiveHolders().create();
    public static final Registry<MapCodec<? extends ChemicalIngredient>> CHEMICAL_INGREDIENT_TYPES = new RegistryBuilder(CHEMICAL_INGREDIENT_TYPE_REGISTRY_NAME).sync(true).create();
    public static final Registry<ModuleData<?>> MODULE_REGISTRY = new RegistryBuilder(MODULE_REGISTRY_NAME).sync(true).create();
    public static final Registry<MapCodec<? extends RobitSkin>> ROBIT_SKIN_SERIALIZER_REGISTRY = new RegistryBuilder(ROBIT_SKIN_SERIALIZER_REGISTRY_NAME).create();
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final Chemical EMPTY_CHEMICAL = new Chemical(ChemicalBuilder.builder());
    public static final Holder<Chemical> EMPTY_CHEMICAL_HOLDER = DeferredHolder.create(EMPTY_CHEMICAL_KEY);
    @ApiStatus.Internal
    private static final ClassLoader SERVICE_CL = MekanismAPI.class.getClassLoader();

    private MekanismAPI() {
    }

    private static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MEKANISM_MODID, (String)path);
    }

    private static <T> ResourceKey<Registry<T>> registryKey(Class<T> compileTimeTypeValidator, String path) {
        return ResourceKey.createRegistryKey((ResourceLocation)MekanismAPI.rl(path));
    }

    private static <T> ResourceKey<Registry<MapCodec<? extends T>>> codecRegistryKey(Class<T> compileTimeTypeValidator, String path) {
        return ResourceKey.createRegistryKey((ResourceLocation)MekanismAPI.rl(path));
    }

    @ApiStatus.Internal
    public static <SERVICE> SERVICE getService(Class<SERVICE> serviceClass) {
        Iterator<SERVICE> service = ServiceLoader.load(serviceClass, SERVICE_CL).iterator();
        if (service.hasNext()) {
            return service.next();
        }
        IllegalStateException illegalStateException = new IllegalStateException("No valid ServiceImpl for " + serviceClass.getSimpleName() + " found");
        logger.error("Failed to load service", (Throwable)illegalStateException);
        logger.error("CL: {} CCL: {}", (Object)SERVICE_CL, (Object)Thread.currentThread().getContextClassLoader());
        throw illegalStateException;
    }
}

